/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.table;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.table.MongoConnectorOptions;
import org.apache.flink.connector.mongodb.table.MongoDynamicTableSink;
import org.apache.flink.connector.mongodb.table.MongoDynamicTableSource;
import org.apache.flink.connector.mongodb.table.config.MongoConfiguration;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class MongoDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "mongodb";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(MongoConnectorOptions.URI);
        requiredOptions.add(MongoConnectorOptions.DATABASE);
        requiredOptions.add(MongoConnectorOptions.COLLECTION);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(MongoConnectorOptions.SCAN_FETCH_SIZE);
        optionalOptions.add(MongoConnectorOptions.SCAN_CURSOR_NO_TIMEOUT);
        optionalOptions.add(MongoConnectorOptions.SCAN_PARTITION_STRATEGY);
        optionalOptions.add(MongoConnectorOptions.SCAN_PARTITION_SIZE);
        optionalOptions.add(MongoConnectorOptions.SCAN_PARTITION_SAMPLES);
        optionalOptions.add(MongoConnectorOptions.SCAN_PARTITION_RECORD_SIZE);
        optionalOptions.add(MongoConnectorOptions.BUFFER_FLUSH_MAX_ROWS);
        optionalOptions.add(MongoConnectorOptions.BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(MongoConnectorOptions.DELIVERY_GUARANTEE);
        optionalOptions.add(MongoConnectorOptions.SINK_MAX_RETRIES);
        optionalOptions.add(MongoConnectorOptions.SINK_RETRY_INTERVAL);
        optionalOptions.add(FactoryUtil.SINK_PARALLELISM);
        optionalOptions.add(LookupOptions.CACHE_TYPE);
        optionalOptions.add(LookupOptions.MAX_RETRIES);
        optionalOptions.add(MongoConnectorOptions.LOOKUP_RETRY_INTERVAL);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_MAX_ROWS);
        optionalOptions.add(LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY);
        optionalOptions.add(MongoConnectorOptions.FILTER_HANDLING_POLICY);
        return optionalOptions;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        HashSet forwardOptions = new HashSet();
        forwardOptions.add(MongoConnectorOptions.URI);
        forwardOptions.add(MongoConnectorOptions.DATABASE);
        forwardOptions.add(MongoConnectorOptions.COLLECTION);
        forwardOptions.add(MongoConnectorOptions.SCAN_FETCH_SIZE);
        forwardOptions.add(MongoConnectorOptions.SCAN_CURSOR_NO_TIMEOUT);
        forwardOptions.add(MongoConnectorOptions.BUFFER_FLUSH_MAX_ROWS);
        forwardOptions.add(MongoConnectorOptions.BUFFER_FLUSH_INTERVAL);
        forwardOptions.add(MongoConnectorOptions.SINK_MAX_RETRIES);
        forwardOptions.add(MongoConnectorOptions.SINK_RETRY_INTERVAL);
        return forwardOptions;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig options = helper.getOptions();
        MongoConfiguration config = new MongoConfiguration(options);
        helper.validate();
        return new MongoDynamicTableSource(MongoDynamicTableFactory.getConnectionOptions(config), MongoDynamicTableFactory.getReadOptions(config), this.getLookupCache(options), config.getLookupMaxRetries(), config.getLookupRetryIntervalMs(), config.getFilterHandlingPolicy(), context.getPhysicalRowDataType());
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        MongoConfiguration config = new MongoConfiguration(helper.getOptions());
        helper.validate();
        return new MongoDynamicTableSink(MongoDynamicTableFactory.getConnectionOptions(config), MongoDynamicTableFactory.getWriteOptions(config), config.getSinkParallelism(), context.getCatalogTable().getResolvedSchema(), context.getCatalogTable().getPartitionKeys().toArray(new String[0]));
    }

    @Nullable
    private LookupCache getLookupCache(ReadableConfig tableOptions) {
        DefaultLookupCache cache = null;
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return cache;
    }

    private static MongoConnectionOptions getConnectionOptions(MongoConfiguration configuration) {
        return MongoConnectionOptions.builder().setUri(configuration.getUri()).setDatabase(configuration.getDatabase()).setCollection(configuration.getCollection()).build();
    }

    private static MongoReadOptions getReadOptions(MongoConfiguration configuration) {
        return MongoReadOptions.builder().setFetchSize(configuration.getFetchSize()).setNoCursorTimeout(configuration.isNoCursorTimeout()).setPartitionStrategy(configuration.getPartitionStrategy()).setPartitionSize(configuration.getPartitionSize()).setPartitionRecordSize(configuration.getPartitionRecordSize()).setSamplesPerPartition(configuration.getSamplesPerPartition()).build();
    }

    private static MongoWriteOptions getWriteOptions(MongoConfiguration configuration) {
        return MongoWriteOptions.builder().setBatchSize(configuration.getBufferFlushMaxRows()).setBatchIntervalMs(configuration.getBufferFlushIntervalMs()).setMaxRetries(configuration.getSinkMaxRetries()).setRetryIntervalMs(configuration.getSinkRetryIntervalMs()).setDeliveryGuarantee(configuration.getDeliveryGuarantee()).build();
    }
}

