/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@ThreadSafe
@Internal
public final class CheckpointAndXid {
    final long checkpointId;
    final Xid xid;
    final int attempts;
    final boolean restored;

    public Xid getXid() {
        return this.xid;
    }

    private CheckpointAndXid(long checkpointId, Xid xid, int attempts, boolean restored) {
        this.checkpointId = checkpointId;
        this.xid = (Xid)Preconditions.checkNotNull((Object)xid);
        this.attempts = attempts;
        this.restored = restored;
    }

    public String toString() {
        return String.format("checkpointId=%d, xid=%s, restored=%s", this.checkpointId, this.xid, this.restored);
    }

    CheckpointAndXid asRestored() {
        return this.restored ? this : new CheckpointAndXid(this.checkpointId, this.xid, this.attempts, true);
    }

    static CheckpointAndXid createRestored(long checkpointId, int attempts, Xid xid) {
        return new CheckpointAndXid(checkpointId, xid, attempts, true);
    }

    static CheckpointAndXid createNew(long checkpointId, Xid xid) {
        return new CheckpointAndXid(checkpointId, xid, 0, false);
    }

    CheckpointAndXid withAttemptsIncremented() {
        return new CheckpointAndXid(this.checkpointId, this.xid, this.attempts + 1, this.restored);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckpointAndXid)) {
            return false;
        }
        CheckpointAndXid that = (CheckpointAndXid)o;
        return this.checkpointId == that.checkpointId && this.attempts == that.attempts && this.restored == that.restored && Objects.equals(this.xid, that.xid);
    }

    public int hashCode() {
        return Objects.hash(this.checkpointId, this.xid, this.attempts, this.restored);
    }
}

