/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class JdbcTypeUtil {
    private static final Map<TypeInformation<?>, Integer> TYPE_MAPPING;
    private static final Map<LogicalTypeRoot, Integer> LOGICAL_TYPE_MAPPING;

    private JdbcTypeUtil() {
    }

    @Deprecated
    public static int typeInformationToSqlType(TypeInformation<?> type) {
        if (TYPE_MAPPING.containsKey(type)) {
            return TYPE_MAPPING.get(type);
        }
        if (type instanceof ObjectArrayTypeInfo || type instanceof PrimitiveArrayTypeInfo) {
            return 2003;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static int logicalTypeToSqlType(LogicalTypeRoot typeRoot) {
        if (LOGICAL_TYPE_MAPPING.containsKey(typeRoot)) {
            return LOGICAL_TYPE_MAPPING.get(typeRoot);
        }
        throw new IllegalArgumentException("Unsupported typeRoot: " + typeRoot);
    }

    static {
        HashMap<Object, Integer> m = new HashMap<Object, Integer>();
        m.put(BasicTypeInfo.STRING_TYPE_INFO, 12);
        m.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, 16);
        m.put(BasicTypeInfo.BYTE_TYPE_INFO, -6);
        m.put(BasicTypeInfo.SHORT_TYPE_INFO, 5);
        m.put(BasicTypeInfo.INT_TYPE_INFO, 4);
        m.put(BasicTypeInfo.LONG_TYPE_INFO, -5);
        m.put(BasicTypeInfo.FLOAT_TYPE_INFO, 7);
        m.put(BasicTypeInfo.DOUBLE_TYPE_INFO, 8);
        m.put(SqlTimeTypeInfo.DATE, 91);
        m.put(SqlTimeTypeInfo.TIME, 92);
        m.put(SqlTimeTypeInfo.TIMESTAMP, 93);
        m.put(LocalTimeTypeInfo.LOCAL_DATE, 91);
        m.put(LocalTimeTypeInfo.LOCAL_TIME, 92);
        m.put(LocalTimeTypeInfo.LOCAL_DATE_TIME, 93);
        m.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, 3);
        m.put(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, -2);
        TYPE_MAPPING = Collections.unmodifiableMap(m);
        LOGICAL_TYPE_MAPPING = Collections.unmodifiableMap(new HashMap<LogicalTypeRoot, Integer>(){
            {
                this.put(LogicalTypeRoot.VARCHAR, 12);
                this.put(LogicalTypeRoot.CHAR, 1);
                this.put(LogicalTypeRoot.VARBINARY, -3);
                this.put(LogicalTypeRoot.BOOLEAN, 16);
                this.put(LogicalTypeRoot.BINARY, -2);
                this.put(LogicalTypeRoot.TINYINT, -6);
                this.put(LogicalTypeRoot.SMALLINT, 5);
                this.put(LogicalTypeRoot.INTEGER, 4);
                this.put(LogicalTypeRoot.BIGINT, -5);
                this.put(LogicalTypeRoot.FLOAT, 7);
                this.put(LogicalTypeRoot.DOUBLE, 8);
                this.put(LogicalTypeRoot.DATE, 91);
                this.put(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, 93);
                this.put(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, 2014);
                this.put(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, 92);
                this.put(LogicalTypeRoot.DECIMAL, 3);
                this.put(LogicalTypeRoot.ARRAY, 2003);
            }
        });
    }
}

