/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CheckpointedPosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NO_OFFSET = -1L;
    private final long offset;
    private final long recordsAfterOffset;

    public CheckpointedPosition(long offset, long recordsAfterOffset) {
        Preconditions.checkArgument((offset >= -1L ? 1 : 0) != 0, (Object)"offset must be >= 0 or NO_OFFSET");
        Preconditions.checkArgument((recordsAfterOffset >= 0L ? 1 : 0) != 0, (Object)"recordsAfterOffset must be >= 0");
        this.offset = offset;
        this.recordsAfterOffset = recordsAfterOffset;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRecordsAfterOffset() {
        return this.recordsAfterOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointedPosition that = (CheckpointedPosition)o;
        return this.offset == that.offset && this.recordsAfterOffset == that.recordsAfterOffset;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.recordsAfterOffset);
    }

    public String toString() {
        return String.format("CheckpointedPosition: offset=%s, recordsToSkip=%d", this.offset == -1L ? "NO_OFFSET" : String.valueOf(this.offset), this.recordsAfterOffset);
    }
}

