/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public class FileSourceSplit
implements SourceSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_HOSTS = StringUtils.EMPTY_STRING_ARRAY;
    private final String id;
    private final Path filePath;
    private final long offset;
    private final long length;
    private final String[] hostnames;
    @Nullable
    private final CheckpointedPosition readerPosition;
    @Nullable
    transient byte[] serializedFormCache;

    public FileSourceSplit(String id, Path filePath, long offset, long length) {
        this(id, filePath, offset, length, NO_HOSTS);
    }

    public FileSourceSplit(String id, Path filePath, long offset, long length, String ... hostnames) {
        this(id, filePath, offset, length, hostnames, (CheckpointedPosition)null, (byte[])null);
    }

    public FileSourceSplit(String id, Path filePath, long offset, long length, String[] hostnames, @Nullable CheckpointedPosition readerPosition) {
        this(id, filePath, offset, length, hostnames, readerPosition, null);
    }

    FileSourceSplit(String id, Path filePath, long offset, long length, String[] hostnames, @Nullable CheckpointedPosition readerPosition, @Nullable byte[] serializedForm) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be >= 0");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be >= 0");
        FileSourceSplit.checkNoNullHosts(hostnames);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
        this.offset = offset;
        this.length = length;
        this.hostnames = hostnames;
        this.readerPosition = readerPosition;
        this.serializedFormCache = serializedForm;
    }

    public String splitId() {
        return this.id;
    }

    public Path path() {
        return this.filePath;
    }

    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    public String[] hostnames() {
        return this.hostnames;
    }

    public Optional<CheckpointedPosition> getReaderPosition() {
        return Optional.ofNullable(this.readerPosition);
    }

    public FileSourceSplit updateWithCheckpointedPosition(@Nullable CheckpointedPosition position) {
        return new FileSourceSplit(this.id, this.filePath, this.offset, this.length, this.hostnames, position);
    }

    public String toString() {
        String hosts = this.hostnames.length == 0 ? "(no host info)" : " hosts=" + Arrays.toString(this.hostnames);
        return String.format("FileSourceSplit: %s [%d, %d) %s ID=%s position=%s", this.filePath, this.offset, this.offset + this.length, hosts, this.id, this.readerPosition);
    }

    private static void checkNoNullHosts(String[] hosts) {
        Preconditions.checkNotNull((Object)hosts, (String)"hostnames array must not be null");
        for (String host : hosts) {
            Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"the hostnames must not contain null entries");
        }
    }
}

