/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.IdentityHashMap;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ServiceFactoryComponentManager
extends ImmediateComponentManager
implements ServiceFactory {
    private IdentityHashMap serviceContexts = new IdentityHashMap();

    public ServiceFactoryComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
        super(activator, componentHolder, metadata);
    }

    protected boolean createComponent() {
        return true;
    }

    protected void deleteComponent() {
    }

    protected Object getService() {
        return this;
    }

    Object getInstance() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.log(4, "ServiceFactory.getService()", null);
        BundleComponentContext serviceContext = new BundleComponentContext(this, bundle);
        Object service = this.createImplementationObject(serviceContext);
        if (service != null) {
            serviceContext.setImplementationObject(service);
            IdentityHashMap identityHashMap = this.serviceContexts;
            synchronized (identityHashMap) {
                this.serviceContexts.put(service, serviceContext);
                if (this.getState() == 32) {
                    this.changeState(AbstractComponentManager.Active.getInstance());
                }
            }
        } else {
            this.log(1, "Failed creating the component instance; see log for reason", null);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        ComponentContext serviceContext;
        this.log(4, "ServiceFactory.ungetService()", null);
        IdentityHashMap identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            serviceContext = (ComponentContext)this.serviceContexts.remove(service);
        }
        this.disposeImplementationObject(service, serviceContext, 5);
        identityHashMap = this.serviceContexts;
        synchronized (identityHashMap) {
            if (this.serviceContexts.isEmpty() && this.getState() == 16) {
                this.changeState(AbstractComponentManager.Registered.getInstance());
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return super.getComponentInstance();
    }

    private static class BundleComponentContext
    extends ComponentContextImpl {
        private Bundle m_usingBundle;
        private Object m_implementationObject;

        BundleComponentContext(AbstractComponentManager componentManager, Bundle usingBundle) {
            super(componentManager);
            this.m_usingBundle = usingBundle;
        }

        private void setImplementationObject(Object implementationObject) {
            this.m_implementationObject = implementationObject;
        }

        public Bundle getUsingBundle() {
            return this.m_usingBundle;
        }

        public Object getInstance() {
            return this.m_implementationObject;
        }
    }
}

