/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.manager.DelayedComponentManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.manager.ServiceFactoryComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

abstract class AbstractComponentHolder
implements ComponentHolder {
    private final BundleComponentActivator m_activator;
    private final ComponentMetadata m_componentMetadata;

    public AbstractComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
    }

    protected ImmediateComponentManager createComponentManager() {
        ImmediateComponentManager manager;
        if (this.m_componentMetadata.isFactory()) {
            throw new IllegalArgumentException("Cannot create component factory for " + this.m_componentMetadata.getName());
        }
        if (this.m_componentMetadata.isImmediate()) {
            manager = new ImmediateComponentManager(this.m_activator, this, this.m_componentMetadata);
        } else if (this.m_componentMetadata.getServiceMetadata() != null) {
            manager = this.m_componentMetadata.getServiceMetadata().isServiceFactory() ? new ServiceFactoryComponentManager(this.m_activator, this, this.m_componentMetadata) : new DelayedComponentManager(this.m_activator, this, this.m_componentMetadata);
        } else {
            throw new IllegalArgumentException("Cannot create a component manager for " + this.m_componentMetadata.getName());
        }
        return manager;
    }

    public final BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    public final ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    protected final String getComponentName() {
        return this.getComponentMetadata().getName();
    }
}

