/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.store.FeedPathStore;
import org.apache.falcon.util.FalconRadixUtils;
import org.apache.falcon.util.RadixNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadixTree<T>
implements FeedPathStore<T>,
Formattable {
    private static final Logger LOG = LoggerFactory.getLogger(RadixTree.class);
    protected RadixNode<T> root = new RadixNode();
    private int size;

    public RadixTree() {
        this.root.setKey("");
        this.size = 0;
    }

    @Override
    public synchronized int getSize() {
        return this.size;
    }

    @Override
    public synchronized void insert(@Nullable String key, @Nonnull T value) {
        if (key != null && !key.trim().isEmpty()) {
            LOG.debug("Insert called for key: {} and value: {}", (Object)key.trim(), value);
            this.insertKeyRecursive(key.trim(), value, this.root);
        }
    }

    private void insertKeyRecursive(String remainingText, T value, RadixNode<T> currentNode) {
        int currentMatchLength = currentNode.getMatchLength(remainingText);
        String newRemainingText = remainingText.substring(currentMatchLength, remainingText.length());
        if (currentNode.isRoot() || currentMatchLength == currentNode.getKey().length() && currentMatchLength < remainingText.length()) {
            boolean foundPath = false;
            for (RadixNode<T> child : currentNode.getChildren()) {
                if (child.getKey().charAt(0) != newRemainingText.charAt(0)) continue;
                this.insertKeyRecursive(newRemainingText, value, child);
                foundPath = true;
                break;
            }
            if (!foundPath) {
                RadixNode<T> node = new RadixNode<T>();
                node.setKey(newRemainingText);
                node.addValue(value);
                node.setTerminal(true);
                currentNode.getChildren().add(node);
                ++this.size;
            }
        } else if (currentMatchLength == remainingText.length() && currentMatchLength < currentNode.getKey().length()) {
            RadixNode<T> node = new RadixNode<T>();
            node.setChildren(currentNode.getChildren());
            node.setKey(currentNode.getKey().substring(currentMatchLength));
            node.setValues(currentNode.getValues());
            node.setTerminal(currentNode.isTerminal());
            currentNode.setChildren(new LinkedList());
            currentNode.getChildren().add(node);
            currentNode.setTerminal(true);
            currentNode.setKey(currentNode.getKey().substring(0, currentMatchLength));
            currentNode.removeAll();
            currentNode.addValue(value);
            ++this.size;
        } else if (currentMatchLength < remainingText.length() && currentMatchLength < currentNode.getKey().length()) {
            RadixNode<T> node = new RadixNode<T>();
            node.setChildren(currentNode.getChildren());
            node.setTerminal(currentNode.isTerminal());
            node.setValues(currentNode.getValues());
            node.setKey(currentNode.getKey().substring(currentMatchLength, currentNode.getKey().length()));
            RadixNode<T> node2 = new RadixNode<T>();
            node2.setKey(newRemainingText);
            node2.setTerminal(true);
            node2.addValue(value);
            currentNode.setTerminal(false);
            currentNode.setKey(currentNode.getKey().substring(0, currentMatchLength));
            currentNode.setChildren(new LinkedList());
            currentNode.getChildren().add(node);
            currentNode.getChildren().add(node2);
            ++this.size;
        } else if (currentMatchLength == remainingText.length() && currentMatchLength == currentNode.getKey().length()) {
            if (currentNode.isTerminal()) {
                currentNode.addValue(value);
            } else {
                currentNode.setTerminal(true);
                currentNode.addValue(value);
            }
            ++this.size;
        }
    }

    @Override
    @Nullable
    public synchronized Collection<T> find(@Nonnull String key, FalconRadixUtils.INodeAlgorithm algorithm) {
        if (key != null && !key.trim().isEmpty()) {
            if (algorithm == null) {
                algorithm = new FalconRadixUtils.StringAlgorithm();
            }
            return this.recursiveFind(key.trim(), this.root, algorithm);
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<T> find(@Nonnull String key) {
        if (key != null && !key.trim().isEmpty()) {
            FalconRadixUtils.StringAlgorithm algorithm = new FalconRadixUtils.StringAlgorithm();
            return this.recursiveFind(key.trim(), this.root, algorithm);
        }
        return null;
    }

    private Collection<T> recursiveFind(String key, RadixNode<T> currentNode, FalconRadixUtils.INodeAlgorithm algorithm) {
        if (!algorithm.startsWith(currentNode.getKey(), key)) {
            LOG.debug("Current Node key: {} is not a prefix in the input key: {}", (Object)currentNode.getKey(), (Object)key);
            return null;
        }
        if (algorithm.match(currentNode.getKey(), key)) {
            if (currentNode.isTerminal()) {
                LOG.debug("Found the terminal node with key: {} for the given input.", (Object)currentNode.getKey());
                return currentNode.getValues();
            }
            LOG.debug("currentNode is not terminal. Current node's key is {}", (Object)currentNode.getKey());
            return null;
        }
        RadixNode newRoot = algorithm.getNextCandidate(currentNode, key);
        String remainingText = algorithm.getRemainingText(currentNode, key);
        if (newRoot == null) {
            LOG.debug("No child found to follow for further processing. Current node key {}");
            return null;
        }
        LOG.debug("Recursing with new key: {} and new remainingText: {}", (Object)newRoot.getKey(), (Object)remainingText);
        return this.recursiveFind(remainingText, newRoot, algorithm);
    }

    @Override
    public synchronized boolean delete(@Nonnull String key, @Nonnull T value) {
        if (key != null && !key.trim().isEmpty()) {
            LOG.debug("Delete called for key:{}", (Object)key.trim());
            return this.recursiveDelete(key, null, this.root, value);
        }
        return false;
    }

    private boolean recursiveDelete(String key, RadixNode<T> parent, RadixNode<T> currentNode, T value) {
        LOG.debug("Recursing with key: {}, currentNode: {}", (Object)key, (Object)currentNode.getKey());
        if (!key.startsWith(currentNode.getKey())) {
            LOG.debug("Current node's key: {} is not a prefix of the remaining input key: {}", (Object)currentNode.getKey(), (Object)key);
            return false;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)currentNode.getKey())) {
            LOG.trace("Current node's key:{} and the input key:{} matched", (Object)currentNode.getKey(), (Object)key);
            if (currentNode.getValues().contains(value)) {
                LOG.debug("Given value is found in the collection of values against the given key");
                currentNode.removeValue(value);
                --this.size;
                if (currentNode.getValues().size() == 0) {
                    LOG.debug("Exact match between current node's key: {} and remaining input key: {}", (Object)currentNode.getKey(), (Object)key);
                    if (currentNode.isTerminal()) {
                        if (currentNode.getChildren().size() == 0) {
                            Iterator<RadixNode<T>> it = parent.getChildren().iterator();
                            while (it.hasNext()) {
                                if (!StringUtils.equals((CharSequence)it.next().getKey(), (CharSequence)currentNode.getKey())) continue;
                                it.remove();
                                LOG.debug("Deleting the node");
                                break;
                            }
                        } else if (currentNode.getChildren().size() > 1) {
                            currentNode.setTerminal(false);
                        } else if (currentNode.getChildren().size() == 1) {
                            LOG.debug("compacting node with child as node to be deleted has only 1 child");
                            RadixNode<T> child = currentNode.getChildren().get(0);
                            currentNode.setChildren(child.getChildren());
                            currentNode.setTerminal(child.isTerminal());
                            currentNode.setKey(currentNode.getKey() + child.getKey());
                            currentNode.setValues(child.getValues());
                        }
                        if (!parent.isTerminal() && !parent.isRoot() && parent.getChildren().size() == 1) {
                            RadixNode<T> onlyChild = parent.getChildren().get(0);
                            String onlyChildKey = onlyChild.getKey();
                            LOG.debug("Compacting child: {} and parent: {}", (Object)onlyChildKey, (Object)parent.getKey());
                            parent.setKey(parent.getKey() + onlyChildKey);
                            parent.setChildren(onlyChild.getChildren());
                            parent.setTerminal(onlyChild.isTerminal());
                            parent.setValues(onlyChild.getValues());
                        }
                        return true;
                    }
                    LOG.debug("Key found only as a prefix and not at a terminal node");
                    return false;
                }
                return true;
            }
            LOG.debug("Current value is not found in the collection of values against the given key, no-op");
            return false;
        }
        LOG.debug("Current node's key: {} is a prefix of the input key: {}", (Object)currentNode.getKey(), (Object)key);
        RadixNode<T> newRoot = null;
        String remainingKey = key.substring(currentNode.getMatchLength(key));
        for (RadixNode<T> el : currentNode.getChildren()) {
            LOG.trace("Finding next child to follow. Current child's key:{}", (Object)el.getKey());
            if (el.getKey().charAt(0) != remainingKey.charAt(0)) continue;
            newRoot = el;
            break;
        }
        if (newRoot == null) {
            LOG.debug("No child was found with common prefix with the remainder key: {}", (Object)key);
            return false;
        }
        LOG.debug("Found a child's key: {} with common prefix, recursing on it", (Object)newRoot.getKey());
        return this.recursiveDelete(remainingKey, currentNode, newRoot, value);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        this.formatNodeTo(formatter, 0, this.root);
    }

    private void formatNodeTo(Formatter formatter, int level, RadixNode<T> node) {
        int i;
        for (i = 0; i < level; ++i) {
            formatter.format(" ", new Object[0]);
        }
        formatter.format("|", new Object[0]);
        for (i = 0; i < level; ++i) {
            formatter.format("-", new Object[0]);
        }
        if (node.isTerminal()) {
            formatter.format("%s[%s]*%n", node.getKey(), node.getValues());
        } else {
            formatter.format("%s%n", node.getKey());
        }
        for (RadixNode<T> child : node.getChildren()) {
            this.formatNodeTo(formatter, level + 1, child);
        }
    }

    @Nullable
    public List<String> findSuffixChildren(String key, int limit) {
        boolean flag;
        if (key == null || limit == 0) {
            return null;
        }
        RadixNode<T> currentNode = this.root;
        String remainingText = key.trim();
        LinkedList<String> result = new LinkedList<String>();
        block0: do {
            flag = false;
            for (RadixNode<T> child : currentNode.getChildren()) {
                LOG.debug("Checking for child key: {} against remainingText: {}", (Object)child.getKey(), (Object)remainingText);
                if (child.getKey().charAt(0) != remainingText.charAt(0)) continue;
                LOG.debug("Child key: {} found to have overlap with the remainingText: {}", (Object)child.getKey(), (Object)remainingText);
                flag = true;
                if (!remainingText.startsWith(child.getKey())) {
                    return null;
                }
                if (StringUtils.equals((CharSequence)child.getKey(), (CharSequence)remainingText)) {
                    int counter = 0;
                    for (RadixNode<T> suffixChild : child.getChildren()) {
                        if (limit >= 0 && counter >= limit) continue;
                        result.add(suffixChild.getKey());
                    }
                    return Collections.unmodifiableList(result);
                }
                remainingText = remainingText.substring(child.getKey().length());
                currentNode = child;
                continue block0;
            }
        } while (flag);
        return null;
    }
}

