/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.SchemaHelper;

public final class DateUtil {
    private static final long MINUTE_IN_MS = 60000L;
    private static final long HOUR_IN_MS = 3600000L;
    private static final long DAY_IN_MS = 86400000L;
    private static final long MONTH_IN_MS = 2678400000L;
    public static final Date NEVER = new Date(Long.parseLong("253379862775000"));
    public static final long HOUR_IN_MILLIS = 3600000L;

    private DateUtil() {
    }

    public static Date getNextMinute(Date time) throws Exception {
        Calendar insCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        insCal.setTime(time);
        insCal.add(12, 1);
        return insCal.getTime();
    }

    public static String getDateFormatFromTime(long milliSeconds) {
        return SchemaHelper.getDateFormat().format(new Date(milliSeconds));
    }

    public static Long getFrequencyInMillis(Frequency frequency) {
        switch (frequency.getTimeUnit()) {
            case months: {
                return 2678400000L * (long)frequency.getFrequencyAsInt();
            }
            case days: {
                return 86400000L * (long)frequency.getFrequencyAsInt();
            }
            case hours: {
                return 3600000L * (long)frequency.getFrequencyAsInt();
            }
            case minutes: {
                return 60000L * (long)frequency.getFrequencyAsInt();
            }
        }
        return null;
    }
}

