/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.expression.ExpressionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    private String domain;

    protected abstract String getPropertyFile();

    protected ApplicationProperties() throws FalconException {
        this.init();
    }

    protected void init() throws FalconException {
        this.setDomain(System.getProperty("falcon.domain", System.getenv("FALCON_DOMAIN")));
        this.loadProperties();
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void loadProperties() throws FalconException {
        String propertyFileName = this.getPropertyFile();
        String confDir = System.getProperty("config.location");
        this.loadProperties(propertyFileName, confDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(String propertyFileName, String confDir) throws FalconException {
        try {
            InputStream resourceAsStream = this.checkConfigLocation(propertyFileName, confDir);
            if (resourceAsStream == null) {
                resourceAsStream = this.checkClassPath(propertyFileName);
            }
            if (resourceAsStream != null) {
                try {
                    this.doLoadProperties(resourceAsStream);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)resourceAsStream);
                }
            }
            throw new FileNotFoundException("Unable to find: " + propertyFileName);
        }
        catch (IOException e) {
            throw new FalconException("Error loading properties file: " + this.getPropertyFile(), e);
        }
    }

    private InputStream checkConfigLocation(String propertyFileName, String confDir) throws FileNotFoundException {
        File fileToLoad;
        FileInputStream resourceAsStream = null;
        if (confDir != null && (fileToLoad = new File(confDir, propertyFileName)).exists() && fileToLoad.isFile() && fileToLoad.canRead()) {
            LOG.info("config.location is set, using: {}/{}", (Object)confDir, (Object)propertyFileName);
            resourceAsStream = new FileInputStream(fileToLoad);
        }
        return resourceAsStream;
    }

    private InputStream checkClassPath(String propertyFileName) {
        InputStream resourceAsStream = null;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        URL resource = clazz.getResource("/" + propertyFileName);
        if (resource != null) {
            LOG.info("Fallback to classpath for: {}", (Object)resource);
            resourceAsStream = clazz.getResourceAsStream("/" + propertyFileName);
        } else {
            resource = clazz.getResource(propertyFileName);
            if (resource != null) {
                LOG.info("Fallback to classpath for: {}", (Object)resource);
                resourceAsStream = clazz.getResourceAsStream(propertyFileName);
            }
        }
        return resourceAsStream;
    }

    private void doLoadProperties(InputStream resourceAsStream) throws IOException, FalconException {
        Properties origProps = new Properties();
        origProps.load(resourceAsStream);
        if (this.domain == null) {
            this.domain = origProps.getProperty("*.domain");
            if (this.domain == null) {
                throw new FalconException("Domain is not set!");
            }
            this.domain = ExpressionHelper.substitute(this.domain);
        }
        LOG.info("Initializing {} properties with domain {}", (Object)this.getClass().getName(), (Object)this.domain);
        Set<String> keys = this.getKeys(origProps.keySet());
        for (String key : keys) {
            String value = origProps.getProperty(this.domain + "." + key, origProps.getProperty("*." + key));
            if (value == null) continue;
            value = ExpressionHelper.substitute(value);
            LOG.debug("{}={}", (Object)key, (Object)value);
            this.put(key, value);
        }
    }

    private Set<String> getKeys(Set<Object> keySet) {
        HashSet<String> keys = new HashSet<String>();
        for (Object keyObj : keySet) {
            String key = (String)keyObj;
            keys.add(key.substring(key.indexOf(46) + 1));
        }
        return keys;
    }

    @Override
    public String getProperty(String key) {
        return StringUtils.trim((String)super.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return StringUtils.trim((String)super.getProperty(key, defaultValue));
    }
}

