/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import org.apache.falcon.FalconException;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.service.Services;
import org.apache.falcon.util.ReflectionUtils;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInitializer.class);
    private final Services services = Services.get();

    public void initialize() throws FalconException {
        String serviceClassNames = StartupProperties.get().getProperty("application.services", "org.apache.falcon.entity.store.ConfigurationStore");
        for (String serviceClassName : serviceClassNames.split(",")) {
            if ((serviceClassName = serviceClassName.trim()).isEmpty()) continue;
            FalconService service = (FalconService)ReflectionUtils.getInstanceByClassName(serviceClassName);
            this.services.register(service);
            LOG.info("Initializing service: {}", (Object)serviceClassName);
            try {
                service.init();
            }
            catch (Throwable t) {
                LOG.error("Failed to initialize service {}", (Object)serviceClassName, (Object)t);
                throw new FalconException(t);
            }
            LOG.info("Service initialized: {}", (Object)serviceClassName);
        }
    }

    public void destroy() throws FalconException {
        for (FalconService service : this.services) {
            LOG.info("Destroying service: {}", (Object)service.getClass().getName());
            try {
                service.destroy();
            }
            catch (Throwable t) {
                LOG.error("Failed to destroy service {}", (Object)service.getClass().getName(), (Object)t);
                throw new FalconException(t);
            }
            LOG.info("Service destroyed: {}", (Object)service.getClass().getName());
        }
    }
}

