/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.service.ProxyUserService;
import org.apache.falcon.service.Services;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrentUser {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentUser.class);
    private static final Logger AUDIT = LoggerFactory.getLogger((String)"AUDIT");
    private final String authenticatedUser;
    private String proxyUser;
    private static final ThreadLocal<CurrentUser> CURRENT_USER = new ThreadLocal();
    private static ConcurrentMap<String, UserGroupInformation> userUgiMap = new ConcurrentHashMap<String, UserGroupInformation>();

    private CurrentUser(String authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
        this.proxyUser = authenticatedUser;
    }

    public static void authenticate(String user) {
        if (StringUtils.isEmpty((CharSequence)user)) {
            throw new IllegalStateException("Bad user name sent for authentication");
        }
        LOG.info("Logging in {}", (Object)user);
        CurrentUser currentUser = new CurrentUser(user);
        CURRENT_USER.set(currentUser);
    }

    public static void proxyDoAsUser(String doAsUser, String proxyHost) throws IOException {
        if (!CurrentUser.isAuthenticated()) {
            throw new IllegalStateException("Authentication not done");
        }
        String currentUser = CurrentUser.CURRENT_USER.get().authenticatedUser;
        if (StringUtils.isNotEmpty((CharSequence)doAsUser) && !doAsUser.equalsIgnoreCase(currentUser)) {
            if (StringUtils.isEmpty((CharSequence)proxyHost)) {
                throw new IllegalArgumentException("proxy host cannot be null or empty");
            }
            ProxyUserService proxyUserService = (ProxyUserService)Services.get().getService(ProxyUserService.SERVICE_NAME);
            try {
                proxyUserService.validate(currentUser, proxyHost, doAsUser);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            CurrentUser user = CURRENT_USER.get();
            LOG.info("Authenticated user {} is proxying doAs user {} from host {}", new Object[]{user.authenticatedUser, doAsUser, proxyHost});
            AUDIT.info("Authenticated user {} is proxying doAs user {} from host {}", new Object[]{user.authenticatedUser, doAsUser, proxyHost});
            user.proxyUser = doAsUser;
        }
    }

    public static void proxy(String aclOwner, String aclGroup) throws IOException {
        if (!CurrentUser.isAuthenticated() || StringUtils.isEmpty((CharSequence)aclOwner)) {
            throw new IllegalStateException("Authentication not done or Bad user name");
        }
        CurrentUser user = CURRENT_USER.get();
        LOG.info("Authenticated user {} is proxying entity owner {}/{}", new Object[]{user.authenticatedUser, aclOwner, aclGroup});
        AUDIT.info("Authenticated user {} is proxying entity owner {}/{}", new Object[]{user.authenticatedUser, aclOwner, aclGroup});
        user.proxyUser = aclOwner;
    }

    public static void clear() {
        CURRENT_USER.remove();
    }

    public static boolean isAuthenticated() {
        CurrentUser user = CURRENT_USER.get();
        return user != null && user.authenticatedUser != null;
    }

    public static String getAuthenticatedUser() {
        CurrentUser user = CURRENT_USER.get();
        if (user == null || user.authenticatedUser == null) {
            throw new IllegalStateException("No user logged into the system");
        }
        return user.authenticatedUser;
    }

    public static UserGroupInformation getAuthenticatedUGI() throws IOException {
        return CurrentUser.isAuthenticated() ? CurrentUser.createProxyUGI(CurrentUser.getAuthenticatedUser()) : UserGroupInformation.getCurrentUser();
    }

    public static String getUser() {
        CurrentUser user = CURRENT_USER.get();
        if (user == null || user.proxyUser == null) {
            throw new IllegalStateException("No user logged into the system");
        }
        return user.proxyUser;
    }

    public static UserGroupInformation createProxyUGI(String proxyUser) throws IOException {
        UserGroupInformation proxyUgi = (UserGroupInformation)userUgiMap.get(proxyUser);
        if (proxyUgi == null) {
            proxyUgi = UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
            userUgiMap.putIfAbsent(proxyUser, proxyUgi);
        }
        return proxyUgi;
    }

    public static UserGroupInformation getProxyUGI() throws IOException {
        return CurrentUser.isAuthenticated() ? CurrentUser.createProxyUGI(CurrentUser.getUser()) : UserGroupInformation.getCurrentUser();
    }

    public static Set<String> getGroupNames() throws IOException {
        HashSet<String> s = new HashSet<String>(Arrays.asList(CurrentUser.getProxyUGI().getGroupNames()));
        return Collections.unmodifiableSet(s);
    }

    public static String getPrimaryGroupName() {
        try {
            String[] groups = CurrentUser.getProxyUGI().getGroupNames();
            if (groups.length > 0) {
                return groups[0];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown";
    }
}

