/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.ProcessHelper;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.ClusterType;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.process.Input;
import org.apache.falcon.entity.v0.process.Inputs;
import org.apache.falcon.entity.v0.process.Output;
import org.apache.falcon.entity.v0.process.Outputs;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.entity.v0.process.Workflow;
import org.apache.falcon.metadata.RelationshipGraphBuilder;
import org.apache.falcon.metadata.RelationshipLabel;
import org.apache.falcon.metadata.RelationshipProperty;
import org.apache.falcon.metadata.RelationshipType;
import org.apache.falcon.workflow.WorkflowExecutionArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRelationshipGraphBuilder
extends RelationshipGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRelationshipGraphBuilder.class);

    public EntityRelationshipGraphBuilder(Graph graph, boolean preserveHistory) {
        super(graph, preserveHistory);
    }

    public void addEntity(Entity entity) {
        EntityType entityType = entity.getEntityType();
        switch (entityType) {
            case CLUSTER: {
                this.addClusterEntity((Cluster)entity);
                break;
            }
            case PROCESS: {
                this.addProcessEntity((Process)entity);
                break;
            }
            case FEED: {
                this.addFeedEntity((Feed)entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid EntityType " + entityType);
            }
        }
    }

    public void addClusterEntity(Cluster clusterEntity) {
        LOG.info("Adding cluster entity: {}", (Object)clusterEntity.getName());
        Vertex clusterVertex = this.addVertex(clusterEntity.getName(), RelationshipType.CLUSTER_ENTITY);
        this.addUserRelation(clusterVertex);
        this.addColoRelation(clusterEntity.getColo(), clusterVertex);
        this.addDataClassification(clusterEntity.getTags(), clusterVertex);
    }

    public void addFeedEntity(Feed feed) {
        LOG.info("Adding feed entity: {}", (Object)feed.getName());
        Vertex feedVertex = this.addVertex(feed.getName(), RelationshipType.FEED_ENTITY);
        this.addUserRelation(feedVertex);
        this.addDataClassification(feed.getTags(), feedVertex);
        this.addGroups(feed.getGroups(), feedVertex);
        for (org.apache.falcon.entity.v0.feed.Cluster feedCluster : feed.getClusters().getClusters()) {
            if (ClusterType.TARGET == feedCluster.getType()) continue;
            this.addRelationToCluster(feedVertex, feedCluster.getName(), RelationshipLabel.FEED_CLUSTER_EDGE);
        }
    }

    public void updateEntity(Entity oldEntity, Entity newEntity) {
        EntityType entityType = oldEntity.getEntityType();
        switch (entityType) {
            case CLUSTER: {
                break;
            }
            case PROCESS: {
                this.updateProcessEntity((Process)oldEntity, (Process)newEntity);
                break;
            }
            case FEED: {
                this.updateFeedEntity((Feed)oldEntity, (Feed)newEntity);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid EntityType " + entityType);
            }
        }
    }

    public void updateFeedEntity(Feed oldFeed, Feed newFeed) {
        LOG.info("Updating feed entity: {}", (Object)newFeed.getName());
        Vertex feedEntityVertex = this.findVertex(oldFeed.getName(), RelationshipType.FEED_ENTITY);
        if (feedEntityVertex == null) {
            LOG.error("Illegal State: Feed entity vertex must exist for {}", (Object)oldFeed.getName());
            throw new IllegalStateException(oldFeed.getName() + " entity vertex must exist.");
        }
        this.updateDataClassification(oldFeed.getTags(), newFeed.getTags(), feedEntityVertex);
        this.updateGroups(oldFeed.getGroups(), newFeed.getGroups(), feedEntityVertex);
        this.updateFeedClusters(oldFeed.getClusters().getClusters(), newFeed.getClusters().getClusters(), feedEntityVertex);
    }

    public void addProcessEntity(Process process) {
        String processName = process.getName();
        LOG.info("Adding process entity: {}", (Object)processName);
        Vertex processVertex = this.addVertex(processName, RelationshipType.PROCESS_ENTITY);
        this.addWorkflowProperties(process.getWorkflow(), processVertex, processName);
        this.addUserRelation(processVertex);
        this.addDataClassification(process.getTags(), processVertex);
        this.addPipelines(process.getPipelines(), processVertex);
        for (org.apache.falcon.entity.v0.process.Cluster cluster : process.getClusters().getClusters()) {
            this.addRelationToCluster(processVertex, cluster.getName(), RelationshipLabel.PROCESS_CLUSTER_EDGE);
        }
        this.addInputFeeds(process.getInputs(), processVertex);
        this.addOutputFeeds(process.getOutputs(), processVertex);
    }

    public void updateProcessEntity(Process oldProcess, Process newProcess) {
        LOG.info("Updating process entity: {}", (Object)newProcess.getName());
        Vertex processEntityVertex = this.findVertex(oldProcess.getName(), RelationshipType.PROCESS_ENTITY);
        if (processEntityVertex == null) {
            LOG.error("Illegal State: Process entity vertex must exist for {}", (Object)oldProcess.getName());
            throw new IllegalStateException(oldProcess.getName() + " entity vertex must exist");
        }
        this.updateWorkflowProperties(oldProcess.getWorkflow(), newProcess.getWorkflow(), processEntityVertex, newProcess.getName());
        this.updateDataClassification(oldProcess.getTags(), newProcess.getTags(), processEntityVertex);
        this.updatePipelines(oldProcess.getPipelines(), newProcess.getPipelines(), processEntityVertex);
        this.updateProcessClusters(oldProcess.getClusters().getClusters(), newProcess.getClusters().getClusters(), processEntityVertex);
        this.updateProcessInputs(oldProcess.getInputs(), newProcess.getInputs(), processEntityVertex);
        this.updateProcessOutputs(oldProcess.getOutputs(), newProcess.getOutputs(), processEntityVertex);
    }

    public void addColoRelation(String colo, Vertex fromVertex) {
        Vertex coloVertex = this.addVertex(colo, RelationshipType.COLO);
        this.addEdge(fromVertex, coloVertex, RelationshipLabel.CLUSTER_COLO.getName());
    }

    public void addRelationToCluster(Vertex fromVertex, String clusterName, RelationshipLabel edgeLabel) {
        Vertex clusterVertex = this.findVertex(clusterName, RelationshipType.CLUSTER_ENTITY);
        if (clusterVertex == null) {
            LOG.error("Illegal State: Cluster entity vertex must exist for {}", (Object)clusterName);
            throw new IllegalStateException("Cluster entity vertex must exist: " + clusterName);
        }
        this.addEdge(fromVertex, clusterVertex, edgeLabel.getName());
    }

    public void addInputFeeds(Inputs inputs, Vertex processVertex) {
        if (inputs == null) {
            return;
        }
        for (Input input : inputs.getInputs()) {
            this.addProcessFeedEdge(processVertex, input.getFeed(), RelationshipLabel.FEED_PROCESS_EDGE);
        }
    }

    public void addOutputFeeds(Outputs outputs, Vertex processVertex) {
        if (outputs == null) {
            return;
        }
        for (Output output : outputs.getOutputs()) {
            this.addProcessFeedEdge(processVertex, output.getFeed(), RelationshipLabel.PROCESS_FEED_EDGE);
        }
    }

    public void addProcessFeedEdge(Vertex processVertex, String feedName, RelationshipLabel edgeLabel) {
        Vertex feedVertex = this.findVertex(feedName, RelationshipType.FEED_ENTITY);
        if (feedVertex == null) {
            LOG.error("Illegal State: Feed entity vertex must exist for {}", (Object)feedName);
            throw new IllegalStateException("Feed entity vertex must exist: " + feedName);
        }
        this.addProcessFeedEdge(processVertex, feedVertex, edgeLabel);
    }

    public void addWorkflowProperties(Workflow workflow, Vertex processVertex, String processName) {
        processVertex.setProperty(WorkflowExecutionArgs.USER_WORKFLOW_NAME.getName(), (Object)ProcessHelper.getProcessWorkflowName(workflow.getName(), processName));
        processVertex.setProperty(RelationshipProperty.VERSION.getName(), (Object)workflow.getVersion());
        processVertex.setProperty(WorkflowExecutionArgs.USER_WORKFLOW_ENGINE.getName(), (Object)workflow.getEngine().value());
    }

    public void updateWorkflowProperties(Workflow oldWorkflow, Workflow newWorkflow, Vertex processEntityVertex, String processName) {
        if (EntityRelationshipGraphBuilder.areSame(oldWorkflow, newWorkflow)) {
            return;
        }
        LOG.info("Updating workflow properties for: {}", (Object)processEntityVertex);
        this.addWorkflowProperties(newWorkflow, processEntityVertex, processName);
    }

    public void updateDataClassification(String oldClassification, String newClassification, Vertex entityVertex) {
        if (EntityRelationshipGraphBuilder.areSame(oldClassification, newClassification)) {
            return;
        }
        this.removeDataClassification(oldClassification, entityVertex);
        this.addDataClassification(newClassification, entityVertex);
    }

    private void removeDataClassification(String classification, Vertex entityVertex) {
        String[] oldTags;
        if (classification == null || classification.length() == 0) {
            return;
        }
        for (String oldTag : oldTags = classification.split(",")) {
            int index = oldTag.indexOf("=");
            String tagKey = oldTag.substring(0, index);
            String tagValue = oldTag.substring(index + 1, oldTag.length());
            this.removeEdge(entityVertex, tagValue, tagKey);
        }
    }

    public void updateGroups(String oldGroups, String newGroups, Vertex entityVertex) {
        if (EntityRelationshipGraphBuilder.areSame(oldGroups, newGroups)) {
            return;
        }
        this.removeGroups(oldGroups, entityVertex);
        this.addGroups(newGroups, entityVertex);
    }

    public void updatePipelines(String oldPipelines, String newPipelines, Vertex entityVertex) {
        if (EntityRelationshipGraphBuilder.areSame(oldPipelines, newPipelines)) {
            return;
        }
        this.removePipelines(oldPipelines, entityVertex);
        this.addPipelines(newPipelines, entityVertex);
    }

    private void removeGroups(String groups, Vertex entityVertex) {
        this.removeGroupsOrPipelines(groups, entityVertex, RelationshipLabel.GROUPS);
    }

    private void removePipelines(String pipelines, Vertex entityVertex) {
        this.removeGroupsOrPipelines(pipelines, entityVertex, RelationshipLabel.PIPELINES);
    }

    private void removeGroupsOrPipelines(String groupsOrPipelines, Vertex entityVertex, RelationshipLabel edgeLabel) {
        String[] oldGroupOrPipelinesTags;
        if (StringUtils.isEmpty((CharSequence)groupsOrPipelines)) {
            return;
        }
        for (String groupOrPipelineTag : oldGroupOrPipelinesTags = groupsOrPipelines.split(",")) {
            this.removeEdge(entityVertex, groupOrPipelineTag, edgeLabel.getName());
        }
    }

    public static boolean areSame(String oldValue, String newValue) {
        return oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue);
    }

    public void updateFeedClusters(List<org.apache.falcon.entity.v0.feed.Cluster> oldClusters, List<org.apache.falcon.entity.v0.feed.Cluster> newClusters, Vertex feedEntityVertex) {
        if (this.areFeedClustersSame(oldClusters, newClusters)) {
            return;
        }
        for (org.apache.falcon.entity.v0.feed.Cluster oldCuster : oldClusters) {
            if (ClusterType.TARGET == oldCuster.getType()) continue;
            this.removeEdge(feedEntityVertex, oldCuster.getName(), RelationshipLabel.FEED_CLUSTER_EDGE.getName());
        }
        for (org.apache.falcon.entity.v0.feed.Cluster newCluster : newClusters) {
            if (ClusterType.TARGET == newCluster.getType()) continue;
            this.addRelationToCluster(feedEntityVertex, newCluster.getName(), RelationshipLabel.FEED_CLUSTER_EDGE);
        }
    }

    public boolean areFeedClustersSame(List<org.apache.falcon.entity.v0.feed.Cluster> oldClusters, List<org.apache.falcon.entity.v0.feed.Cluster> newClusters) {
        if (oldClusters.size() != newClusters.size()) {
            return false;
        }
        List<String> oldClusterNames = this.getFeedClusterNames(oldClusters);
        List<String> newClusterNames = this.getFeedClusterNames(newClusters);
        return oldClusterNames.size() == newClusterNames.size() && oldClusterNames.containsAll(newClusterNames) && newClusterNames.containsAll(oldClusterNames);
    }

    public List<String> getFeedClusterNames(List<org.apache.falcon.entity.v0.feed.Cluster> clusters) {
        ArrayList<String> clusterNames = new ArrayList<String>(clusters.size());
        for (org.apache.falcon.entity.v0.feed.Cluster cluster : clusters) {
            clusterNames.add(cluster.getName());
        }
        return clusterNames;
    }

    public void updateProcessClusters(List<org.apache.falcon.entity.v0.process.Cluster> oldClusters, List<org.apache.falcon.entity.v0.process.Cluster> newClusters, Vertex processEntityVertex) {
        if (this.areProcessClustersSame(oldClusters, newClusters)) {
            return;
        }
        for (org.apache.falcon.entity.v0.process.Cluster oldCuster : oldClusters) {
            this.removeEdge(processEntityVertex, oldCuster.getName(), RelationshipLabel.PROCESS_CLUSTER_EDGE.getName());
        }
        for (org.apache.falcon.entity.v0.process.Cluster newCluster : newClusters) {
            this.addRelationToCluster(processEntityVertex, newCluster.getName(), RelationshipLabel.PROCESS_CLUSTER_EDGE);
        }
    }

    public boolean areProcessClustersSame(List<org.apache.falcon.entity.v0.process.Cluster> oldClusters, List<org.apache.falcon.entity.v0.process.Cluster> newClusters) {
        if (oldClusters.size() != newClusters.size()) {
            return false;
        }
        List<String> oldClusterNames = this.getProcessClusterNames(oldClusters);
        List<String> newClusterNames = this.getProcessClusterNames(newClusters);
        return oldClusterNames.size() == newClusterNames.size() && oldClusterNames.containsAll(newClusterNames) && newClusterNames.containsAll(oldClusterNames);
    }

    public List<String> getProcessClusterNames(List<org.apache.falcon.entity.v0.process.Cluster> clusters) {
        ArrayList<String> clusterNames = new ArrayList<String>(clusters.size());
        for (org.apache.falcon.entity.v0.process.Cluster cluster : clusters) {
            clusterNames.add(cluster.getName());
        }
        return clusterNames;
    }

    public static boolean areSame(Workflow oldWorkflow, Workflow newWorkflow) {
        return EntityRelationshipGraphBuilder.areSame(oldWorkflow.getName(), newWorkflow.getName()) && EntityRelationshipGraphBuilder.areSame(oldWorkflow.getVersion(), newWorkflow.getVersion()) && EntityRelationshipGraphBuilder.areSame(oldWorkflow.getEngine().value(), newWorkflow.getEngine().value());
    }

    private void updateProcessInputs(Inputs oldProcessInputs, Inputs newProcessInputs, Vertex processEntityVertex) {
        if (EntityRelationshipGraphBuilder.areSame(oldProcessInputs, newProcessInputs)) {
            return;
        }
        this.removeInputFeeds(oldProcessInputs, processEntityVertex);
        this.addInputFeeds(newProcessInputs, processEntityVertex);
    }

    public static boolean areSame(Inputs oldProcessInputs, Inputs newProcessInputs) {
        if (oldProcessInputs == null && newProcessInputs == null) {
            return true;
        }
        if (oldProcessInputs == null || newProcessInputs == null || oldProcessInputs.getInputs().size() != newProcessInputs.getInputs().size()) {
            return false;
        }
        List oldInputs = oldProcessInputs.getInputs();
        List newInputs = newProcessInputs.getInputs();
        return oldInputs.size() == newInputs.size() && oldInputs.containsAll(newInputs) && newInputs.containsAll(oldInputs);
    }

    public void removeInputFeeds(Inputs inputs, Vertex processVertex) {
        if (inputs == null) {
            return;
        }
        for (Input input : inputs.getInputs()) {
            this.removeProcessFeedEdge(processVertex, input.getFeed(), RelationshipLabel.FEED_PROCESS_EDGE);
        }
    }

    public void removeOutputFeeds(Outputs outputs, Vertex processVertex) {
        if (outputs == null) {
            return;
        }
        for (Output output : outputs.getOutputs()) {
            this.removeProcessFeedEdge(processVertex, output.getFeed(), RelationshipLabel.PROCESS_FEED_EDGE);
        }
    }

    public void removeProcessFeedEdge(Vertex processVertex, String feedName, RelationshipLabel edgeLabel) {
        Vertex feedVertex = this.findVertex(feedName, RelationshipType.FEED_ENTITY);
        if (feedVertex == null) {
            LOG.error("Illegal State: Feed entity vertex must exist for {}", (Object)feedName);
            throw new IllegalStateException("Feed entity vertex must exist: " + feedName);
        }
        if (edgeLabel == RelationshipLabel.FEED_PROCESS_EDGE) {
            this.removeEdge(feedVertex, processVertex, edgeLabel.getName());
        } else {
            this.removeEdge(processVertex, feedVertex, edgeLabel.getName());
        }
    }

    private void updateProcessOutputs(Outputs oldProcessOutputs, Outputs newProcessOutputs, Vertex processEntityVertex) {
        if (EntityRelationshipGraphBuilder.areSame(oldProcessOutputs, newProcessOutputs)) {
            return;
        }
        this.removeOutputFeeds(oldProcessOutputs, processEntityVertex);
        this.addOutputFeeds(newProcessOutputs, processEntityVertex);
    }

    public static boolean areSame(Outputs oldProcessOutputs, Outputs newProcessOutputs) {
        if (oldProcessOutputs == null && newProcessOutputs == null) {
            return true;
        }
        if (oldProcessOutputs == null || newProcessOutputs == null || oldProcessOutputs.getOutputs().size() != newProcessOutputs.getOutputs().size()) {
            return false;
        }
        List oldOutputs = oldProcessOutputs.getOutputs();
        List newOutputs = newProcessOutputs.getOutputs();
        return oldOutputs.size() == newOutputs.size() && oldOutputs.containsAll(newOutputs) && newOutputs.containsAll(oldOutputs);
    }
}

