/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.expression;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.common.FeedDataPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpressionHelper
implements FunctionMapper,
VariableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionHelper.class);
    private static final ExpressionHelper INSTANCE = new ExpressionHelper();
    private static final ThreadLocal<Properties> THREAD_VARIABLES = new ThreadLocal();
    private static final Pattern SYS_PROPERTY_PATTERN = Pattern.compile("\\$\\{[A-Za-z0-9_.]+\\}");
    private static final ExpressionEvaluator EVALUATOR = new ExpressionEvaluatorImpl();
    private static final ExpressionHelper RESOLVER = ExpressionHelper.get();
    public static final ThreadLocal<SimpleDateFormat> FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };
    private static ThreadLocal<Date> referenceDate = new ThreadLocal();

    public static ExpressionHelper get() {
        return INSTANCE;
    }

    private ExpressionHelper() {
    }

    public <T> T evaluate(String expression, Class<T> clazz) throws FalconException {
        return this.evaluateFullExpression("${" + expression + "}", clazz);
    }

    public <T> T evaluateFullExpression(String expression, Class<T> clazz) throws FalconException {
        try {
            return (T)EVALUATOR.evaluate(expression, clazz, (VariableResolver)RESOLVER, (FunctionMapper)RESOLVER);
        }
        catch (ELException e) {
            throw new FalconException("Unable to evaluate " + expression, e);
        }
    }

    public Method resolveFunction(String prefix, String name) {
        for (Method method : ExpressionHelper.class.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        throw new UnsupportedOperationException("Not found " + prefix + ":" + name);
    }

    public void setPropertiesForVariable(Properties properties) {
        THREAD_VARIABLES.set(properties);
    }

    public Object resolveVariable(String field) {
        return THREAD_VARIABLES.get().get(field);
    }

    public static void setReferenceDate(Date date) {
        referenceDate.set(date);
        Properties variables = ExpressionHelper.getTimeVariables(date, TimeZone.getTimeZone("UTC"));
        THREAD_VARIABLES.set(variables);
    }

    public static Properties getTimeVariables(Date date, TimeZone tz) {
        Properties vars = new Properties();
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(date);
        vars.put(FeedDataPath.VARS.YEAR.name(), String.format("%04d", cal.get(1)));
        vars.put(FeedDataPath.VARS.MONTH.name(), String.format("%02d", cal.get(2) + 1));
        vars.put(FeedDataPath.VARS.DAY.name(), String.format("%02d", cal.get(5)));
        vars.put(FeedDataPath.VARS.HOUR.name(), String.format("%02d", cal.get(11)));
        vars.put(FeedDataPath.VARS.MINUTE.name(), String.format("%02d", cal.get(12)));
        return vars;
    }

    private static int getDayOffset(String weekDayName) {
        Calendar nominalTime = Calendar.getInstance();
        nominalTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        nominalTime.setTime(referenceDate.get());
        int currentWeekDay = nominalTime.get(7);
        int weekDay = DayOfWeek.valueOf(weekDayName).ordinal() + 1;
        int day = weekDay - currentWeekDay;
        if (weekDay > currentWeekDay) {
            day -= 7;
        }
        return day;
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private static Date getRelative(Date date, int boundary, int month, int day, int hour, int minute) {
        Calendar dsInstanceCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dsInstanceCal.setTime(date);
        switch (boundary) {
            case 1: {
                dsInstanceCal.set(2, 0);
            }
            case 2: {
                dsInstanceCal.set(5, 1);
            }
            case 5: {
                dsInstanceCal.set(11, 0);
            }
            case 10: {
                dsInstanceCal.set(12, 0);
                dsInstanceCal.set(13, 0);
                dsInstanceCal.set(14, 0);
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid boundary " + boundary);
            }
        }
        dsInstanceCal.add(1, 0);
        dsInstanceCal.add(2, month);
        dsInstanceCal.add(5, day);
        dsInstanceCal.add(11, hour);
        dsInstanceCal.add(12, minute);
        return dsInstanceCal.getTime();
    }

    public static Date now(int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 13, 0, 0, hour, minute);
    }

    public static Date today(int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 5, 0, 0, hour, minute);
    }

    public static Date yesterday(int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 5, 0, -1, hour, minute);
    }

    public static Date currentMonth(int day, int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 2, 0, day, hour, minute);
    }

    public static Date lastMonth(int day, int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 2, -1, day, hour, minute);
    }

    public static Date currentWeek(String weekDay, int hour, int minute) {
        int day = ExpressionHelper.getDayOffset(weekDay);
        return ExpressionHelper.getRelative(referenceDate.get(), 5, 0, day, hour, minute);
    }

    public static Date lastWeek(String weekDay, int hour, int minute) {
        int day = ExpressionHelper.getDayOffset(weekDay);
        return ExpressionHelper.getRelative(referenceDate.get(), 5, 0, day - 7, hour, minute);
    }

    public static Date currentYear(int month, int day, int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 1, month, day, hour, minute);
    }

    public static Date lastYear(int month, int day, int hour, int minute) {
        return ExpressionHelper.getRelative(referenceDate.get(), 1, month - 12, day, hour, minute);
    }

    public static Date latest(int n) {
        return referenceDate.get();
    }

    public static Date future(int n, int limit) {
        return referenceDate.get();
    }

    public static long hours(int val) {
        return TimeUnit.HOURS.toMillis(val);
    }

    public static long minutes(int val) {
        return TimeUnit.MINUTES.toMillis(val);
    }

    public static long days(int val) {
        return TimeUnit.DAYS.toMillis(val);
    }

    public static long months(int val) {
        return (long)val * ExpressionHelper.days(31);
    }

    public static long years(int val) {
        return (long)val * ExpressionHelper.days(366);
    }

    public static String substitute(String originalValue) {
        return ExpressionHelper.substitute(originalValue, System.getProperties());
    }

    public static String substitute(String originalValue, Properties properties) {
        Matcher envVarMatcher = SYS_PROPERTY_PATTERN.matcher(originalValue);
        while (envVarMatcher.find()) {
            String envVar = originalValue.substring(envVarMatcher.start() + 2, envVarMatcher.end() - 1);
            String envVal = properties.getProperty(envVar, System.getenv(envVar));
            envVar = "\\$\\{" + envVar + "\\}";
            if (envVal == null) continue;
            originalValue = originalValue.replaceAll(envVar, Matcher.quoteReplacement(envVal));
            envVarMatcher = SYS_PROPERTY_PATTERN.matcher(originalValue);
        }
        return originalValue;
    }

    private static enum DayOfWeek {
        SUN,
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

    }
}

