/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.jsp.el.ELException;
import org.apache.falcon.FalconException;
import org.apache.falcon.Pair;
import org.apache.falcon.catalog.AbstractCatalogService;
import org.apache.falcon.catalog.CatalogPartition;
import org.apache.falcon.catalog.CatalogServiceFactory;
import org.apache.falcon.entity.ClusterHelper;
import org.apache.falcon.entity.FeedInstanceStatus;
import org.apache.falcon.entity.Storage;
import org.apache.falcon.entity.common.FeedDataPath;
import org.apache.falcon.entity.v0.AccessControlList;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.cluster.Interfacetype;
import org.apache.falcon.entity.v0.feed.CatalogTable;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.LocationType;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.retention.EvictedInstanceSerDe;
import org.apache.falcon.retention.EvictionHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogStorage
extends Configured
implements Storage {
    private static final Logger LOG = LoggerFactory.getLogger(EvictionHelper.class);
    private static final String FILTER_ST_BRACKET = "(";
    private static final String FILTER_END_BRACKET = ")";
    private static final String FILTER_QUOTE = "'";
    private static final String FILTER_AND = " and ";
    private static final String FILTER_OR = " or ";
    private static final String FILTER_LESS_THAN = " < ";
    private static final String FILTER_EQUALS = " = ";
    private final StringBuffer instancePaths = new StringBuffer();
    private final StringBuilder instanceDates = new StringBuilder();
    public static final String PARTITION_SEPARATOR = ";";
    public static final String PARTITION_KEYVAL_SEPARATOR = "=";
    public static final String INPUT_PATH_SEPARATOR = ":";
    public static final String OUTPUT_PATH_SEPARATOR = "/";
    public static final String PARTITION_VALUE_QUOTE = "'";
    public static final String CATALOG_URL = "${hcatNode}";
    private final String catalogUrl;
    private String database;
    private String table;
    private Map<String, String> partitions;

    protected CatalogStorage(Feed feed) throws URISyntaxException {
        this(CATALOG_URL, feed.getTable());
    }

    public CatalogStorage(Cluster cluster, CatalogTable table) throws URISyntaxException {
        this(ClusterHelper.getInterface(cluster, Interfacetype.REGISTRY).getEndpoint(), table);
    }

    protected CatalogStorage(String catalogUrl, CatalogTable table) throws URISyntaxException {
        this(catalogUrl, table.getUri());
    }

    protected CatalogStorage(String catalogUrl, String tableUri) throws URISyntaxException {
        if (catalogUrl == null || catalogUrl.length() == 0) {
            throw new IllegalArgumentException("Catalog Registry URL cannot be null or empty");
        }
        this.catalogUrl = catalogUrl;
        this.parseFeedUri(tableUri);
    }

    private void parseFeedUri(String catalogTableUri) throws URISyntaxException {
        String[] parts;
        String processed = catalogTableUri.replaceAll("\\$\\{", "_D__START_").replaceAll("}", "_CLOSE_");
        URI tableUri = new URI(processed);
        if (!"catalog".equals(tableUri.getScheme())) {
            throw new URISyntaxException(tableUri.toString(), "catalog scheme is missing");
        }
        String schemeSpecificPart = tableUri.getSchemeSpecificPart();
        if (schemeSpecificPart == null) {
            throw new URISyntaxException(tableUri.toString(), "Database and Table are missing");
        }
        String[] paths = schemeSpecificPart.split(INPUT_PATH_SEPARATOR);
        if (paths.length != 2) {
            throw new URISyntaxException(tableUri.toString(), "URI path is not in expected format: database:table");
        }
        this.database = paths[0];
        this.table = paths[1];
        if (this.database == null || this.database.length() == 0) {
            throw new URISyntaxException(tableUri.toString(), "DB name is missing");
        }
        if (this.table == null || this.table.length() == 0) {
            throw new URISyntaxException(tableUri.toString(), "Table name is missing");
        }
        String partRaw = tableUri.getFragment();
        if (partRaw == null || partRaw.length() == 0) {
            throw new URISyntaxException(tableUri.toString(), "Partition details are missing");
        }
        String rawPartition = partRaw.replaceAll("_D__START_", "\\$\\{").replaceAll("_CLOSE_", "\\}");
        this.partitions = new LinkedHashMap<String, String>();
        for (String part : parts = rawPartition.split(PARTITION_SEPARATOR)) {
            if (part == null || part.length() == 0) continue;
            String[] keyVal = part.split(PARTITION_KEYVAL_SEPARATOR);
            if (keyVal.length != 2) {
                throw new URISyntaxException(tableUri.toString(), "Partition key value pair is not specified properly in (" + part + FILTER_END_BRACKET);
            }
            this.partitions.put(keyVal[0], keyVal[1]);
        }
    }

    protected CatalogStorage(String uriTemplate) throws URISyntaxException {
        if (uriTemplate == null || uriTemplate.length() == 0) {
            throw new IllegalArgumentException("URI template cannot be null or empty");
        }
        String processed = uriTemplate.replaceAll("\\$\\{", "_D__START_").replaceAll("}", "_CLOSE_");
        URI uri = new URI(processed);
        this.catalogUrl = uri.getScheme() + "://" + uri.getAuthority();
        this.parseUriTemplate(uri);
    }

    protected CatalogStorage(String uriTemplate, Configuration conf) throws URISyntaxException {
        this(uriTemplate);
        this.setConf(conf);
    }

    private void parseUriTemplate(URI uriTemplate) throws URISyntaxException {
        String[] parts;
        String path = uriTemplate.getPath();
        String[] paths = path.split(OUTPUT_PATH_SEPARATOR);
        if (paths.length != 4) {
            throw new URISyntaxException(uriTemplate.toString(), "URI path is not in expected format: database:table");
        }
        this.database = paths[1];
        this.table = paths[2];
        String partRaw = paths[3];
        if (this.database == null || this.database.length() == 0) {
            throw new URISyntaxException(uriTemplate.toString(), "DB name is missing");
        }
        if (this.table == null || this.table.length() == 0) {
            throw new URISyntaxException(uriTemplate.toString(), "Table name is missing");
        }
        if (partRaw == null || partRaw.length() == 0) {
            throw new URISyntaxException(uriTemplate.toString(), "Partition details are missing");
        }
        String rawPartition = partRaw.replaceAll("_D__START_", "\\$\\{").replaceAll("_CLOSE_", "\\}");
        this.partitions = new LinkedHashMap<String, String>();
        for (String part : parts = rawPartition.split(PARTITION_SEPARATOR)) {
            if (part == null || part.length() == 0) continue;
            String[] keyVal = part.split(PARTITION_KEYVAL_SEPARATOR);
            if (keyVal.length != 2) {
                throw new URISyntaxException(uriTemplate.toString(), "Partition key value pair is not specified properly in (" + part + FILTER_END_BRACKET);
            }
            this.partitions.put(keyVal[0], keyVal[1]);
        }
    }

    public String getCatalogUrl() {
        return this.catalogUrl;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getPartitions() {
        return this.partitions;
    }

    public String getPartitionValue(String key) {
        return this.partitions.get(key);
    }

    public boolean hasPartition(String key) {
        return this.partitions.containsKey(key);
    }

    public List<String> getDatedPartitionKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.getPartitions().entrySet()) {
            Matcher matcher = FeedDataPath.PATTERN.matcher(entry.getValue());
            if (!matcher.find()) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public String toPartitionFilter() {
        StringBuilder filter = new StringBuilder();
        filter.append(FILTER_ST_BRACKET);
        for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
            if (filter.length() > 1) {
                filter.append(PARTITION_SEPARATOR);
            }
            filter.append(entry.getKey());
            filter.append(PARTITION_KEYVAL_SEPARATOR);
            filter.append("'");
            filter.append(entry.getValue());
            filter.append("'");
        }
        filter.append(FILTER_END_BRACKET);
        return filter.toString();
    }

    public String toPartitionAsPath() {
        StringBuilder partitionFilter = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getPartitions().entrySet()) {
            partitionFilter.append(entry.getKey()).append(PARTITION_KEYVAL_SEPARATOR).append(entry.getValue()).append(OUTPUT_PATH_SEPARATOR);
        }
        partitionFilter.setLength(partitionFilter.length() - 1);
        return partitionFilter.toString();
    }

    @Override
    public Storage.TYPE getType() {
        return Storage.TYPE.TABLE;
    }

    @Override
    public String getUriTemplate() {
        return this.getUriTemplate(LocationType.DATA);
    }

    @Override
    public String getUriTemplate(LocationType locationType) {
        StringBuilder uriTemplate = new StringBuilder();
        uriTemplate.append(this.catalogUrl);
        uriTemplate.append(OUTPUT_PATH_SEPARATOR);
        uriTemplate.append(this.database);
        uriTemplate.append(OUTPUT_PATH_SEPARATOR);
        uriTemplate.append(this.table);
        uriTemplate.append(OUTPUT_PATH_SEPARATOR);
        for (Map.Entry<String, String> entry : this.partitions.entrySet()) {
            uriTemplate.append(entry.getKey());
            uriTemplate.append(PARTITION_KEYVAL_SEPARATOR);
            uriTemplate.append(entry.getValue());
            uriTemplate.append(PARTITION_SEPARATOR);
        }
        uriTemplate.setLength(uriTemplate.length() - 1);
        return uriTemplate.toString();
    }

    @Override
    public boolean isIdentical(Storage toCompareAgainst) throws FalconException {
        if (!(toCompareAgainst instanceof CatalogStorage)) {
            return false;
        }
        CatalogStorage catalogStorage = (CatalogStorage)toCompareAgainst;
        return (this.getCatalogUrl() == null || this.getCatalogUrl().equals(catalogStorage.getCatalogUrl())) && this.getDatabase().equals(catalogStorage.getDatabase()) && this.getTable().equals(catalogStorage.getTable()) && this.getPartitions().equals(catalogStorage.getPartitions());
    }

    @Override
    public void validateACL(AccessControlList acl) throws FalconException {
    }

    @Override
    public List<FeedInstanceStatus> getListing(Feed feed, String cluster, LocationType locationType, Date start, Date end) throws FalconException {
        throw new UnsupportedOperationException("getListing");
    }

    @Override
    public FeedInstanceStatus.AvailabilityStatus getInstanceAvailabilityStatus(Feed feed, String clusterName, LocationType locationType, Date instancetime) throws FalconException {
        throw new UnsupportedOperationException("getInstanceAvailabilityStatus");
    }

    @Override
    public StringBuilder evict(String retentionLimit, String timeZone, Path logFilePath) throws FalconException {
        List<CatalogPartition> toBeDeleted;
        LOG.info("Applying retention on {}, Limit: {}, timezone: {}", new Object[]{this.getTable(), retentionLimit, timeZone});
        try {
            toBeDeleted = this.discoverPartitionsToDelete(retentionLimit, timeZone);
        }
        catch (ELException e) {
            throw new FalconException("Couldn't find partitions to be deleted", e);
        }
        if (toBeDeleted.isEmpty()) {
            LOG.info("No partitions to delete.");
        } else {
            boolean isTableExternal = CatalogServiceFactory.getCatalogService().isTableExternal(this.getConf(), this.getCatalogUrl(), this.getDatabase(), this.getTable());
            try {
                this.dropPartitions(toBeDeleted, isTableExternal);
            }
            catch (IOException e) {
                throw new FalconException("Couldn't drop partitions", e);
            }
        }
        try {
            EvictedInstanceSerDe.serializeEvictedInstancePaths(HadoopClientFactory.get().createProxiedFileSystem(logFilePath.toUri(), new Configuration()), logFilePath, this.instancePaths);
        }
        catch (IOException e) {
            throw new FalconException("Couldn't record dropped partitions", e);
        }
        return this.instanceDates;
    }

    private List<CatalogPartition> discoverPartitionsToDelete(String retentionLimit, String timezone) throws FalconException, ELException {
        Pair<Date, Date> range = EvictionHelper.getDateRange(retentionLimit);
        ExpressionHelper.setReferenceDate((Date)range.first);
        LinkedHashMap<String, String> partitionsToDelete = new LinkedHashMap<String, String>();
        ExpressionHelper expressionHelper = ExpressionHelper.get();
        for (Map.Entry<String, String> entry : this.getPartitions().entrySet()) {
            if (!FeedDataPath.PATTERN.matcher(entry.getValue()).find()) continue;
            partitionsToDelete.put(entry.getKey(), expressionHelper.evaluateFullExpression(entry.getValue(), String.class));
        }
        String filter = this.createFilter(partitionsToDelete);
        return CatalogServiceFactory.getCatalogService().listPartitionsByFilter(this.getConf(), this.getCatalogUrl(), this.getDatabase(), this.getTable(), filter);
    }

    private String createFilter(Map<String, String> partitionsMap) throws ELException {
        StringBuilder filterBuffer = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(partitionsMap.keySet());
        for (int curr = 0; curr < partitionsMap.size(); ++curr) {
            if (curr > 0) {
                filterBuffer.append(FILTER_OR);
            }
            filterBuffer.append(FILTER_ST_BRACKET);
            for (int prev = 0; prev < curr; ++prev) {
                String key = (String)keys.get(prev);
                filterBuffer.append(key).append(FILTER_EQUALS).append("'").append(partitionsMap.get(key)).append("'").append(FILTER_AND);
            }
            String key = (String)keys.get(curr);
            filterBuffer.append(key).append(FILTER_LESS_THAN).append("'").append(partitionsMap.get(key)).append("'").append(FILTER_END_BRACKET);
        }
        return filterBuffer.toString();
    }

    private void dropPartitions(List<CatalogPartition> partitionsToDelete, boolean isTableExternal) throws FalconException, IOException {
        AbstractCatalogService catalogService = CatalogServiceFactory.getCatalogService();
        for (CatalogPartition partition : partitionsToDelete) {
            boolean deleted = catalogService.dropPartition(this.getConf(), this.getCatalogUrl(), this.getDatabase(), this.getTable(), partition.getValues(), true);
            if (!deleted) {
                return;
            }
            if (isTableExternal) {
                Path path = new Path(partition.getLocation());
                if (!HadoopClientFactory.get().createProxiedFileSystem(path.toUri()).delete(path, true)) {
                    throw new FalconException("Failed to delete location " + path + " for partition " + partition.getValues());
                }
            }
            String partitionInfo = partition.getValues().toString().replace(",", PARTITION_SEPARATOR);
            LOG.info("Deleted partition: " + partitionInfo);
            this.instanceDates.append(partitionInfo).append(',');
            this.instancePaths.append(partition.getLocation()).append(",");
        }
    }

    public String toString() {
        return "CatalogStorage{catalogUrl='" + this.catalogUrl + '\'' + ", database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", partitions=" + this.partitions + '}';
    }
}

