/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.producer;

import io.cloudevents.CloudEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.CloudEventProducer;
import org.apache.eventmesh.client.grpc.util.EventMeshClientUtil;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcProducer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EventMeshGrpcProducer.class);
    private static final String PROTOCOL_TYPE = "eventmeshmessage";
    private final EventMeshGrpcClientConfig clientConfig;
    private ManagedChannel channel;
    PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient;
    CloudEventProducer cloudEventProducer;

    public EventMeshGrpcProducer(EventMeshGrpcClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.clientConfig.getServerAddr(), (int)this.clientConfig.getServerPort()).usePlaintext().build();
        this.publisherClient = PublisherServiceGrpc.newBlockingStub((Channel)this.channel);
        this.cloudEventProducer = new CloudEventProducer(this.clientConfig, this.publisherClient);
    }

    public Response publish(EventMeshMessage message) {
        logger.info("Publish message " + message.toString());
        SimpleMessage simpleMessage = EventMeshClientUtil.buildSimpleMessage(message, this.clientConfig, PROTOCOL_TYPE);
        try {
            Response response = this.publisherClient.publish(simpleMessage);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in publishing message {}, error {}", (Object)message, (Object)e.getMessage());
            return null;
        }
    }

    public <T> Response publish(List<T> messageList) {
        logger.info("BatchPublish message " + messageList.toString());
        if (messageList.size() == 0) {
            return null;
        }
        if (messageList.get(0) instanceof CloudEvent) {
            return this.cloudEventProducer.publish(messageList);
        }
        BatchMessage batchMessage = EventMeshClientUtil.buildBatchMessages(messageList, this.clientConfig, PROTOCOL_TYPE);
        try {
            Response response = this.publisherClient.batchPublish(batchMessage);
            logger.info("Received response " + response.toString());
            return response;
        }
        catch (Exception e) {
            logger.error("Error in BatchPublish message {}, error {}", messageList, (Object)e.getMessage());
            return null;
        }
    }

    public Response publish(CloudEvent cloudEvent) {
        return this.cloudEventProducer.publish(cloudEvent);
    }

    public CloudEvent requestReply(CloudEvent cloudEvent, int timeout) {
        return this.cloudEventProducer.requestReply(cloudEvent, timeout);
    }

    public EventMeshMessage requestReply(EventMeshMessage message, int timeout) {
        logger.info("RequestReply message " + message.toString());
        SimpleMessage simpleMessage = EventMeshClientUtil.buildSimpleMessage(message, this.clientConfig, PROTOCOL_TYPE);
        try {
            SimpleMessage reply = ((PublisherServiceGrpc.PublisherServiceBlockingStub)this.publisherClient.withDeadlineAfter((long)timeout, TimeUnit.MILLISECONDS)).requestReply(simpleMessage);
            logger.info("Received reply message" + reply.toString());
            Object msg = EventMeshClientUtil.buildMessage(reply, PROTOCOL_TYPE);
            if (msg instanceof EventMeshMessage) {
                return (EventMeshMessage)msg;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error in RequestReply message {}, error {}", (Object)message, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }
}

