/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.IPUtils;

public class CommonConfiguration {
    public String eventMeshEnv = "P";
    public String eventMeshIDC = "FT";
    public String eventMeshCluster = "LS";
    public String eventMeshName = "";
    public String sysID = "5477";
    public String eventMeshConnectorPluginType = "rocketmq";
    public String eventMeshSecurityPluginType = "security";
    public String eventMeshRegistryPluginType = "namesrv";
    public List<String> eventMeshMetricsPluginType;
    public String eventMeshTracePluginType;
    public String namesrvAddr = "";
    public String eventMeshRegistryPluginUsername = "";
    public String eventMeshRegistryPluginPassword = "";
    public Integer eventMeshRegisterIntervalInMills = 10000;
    public Integer eventMeshFetchRegistryAddrInterval = 10000;
    public String eventMeshServerIp = null;
    public boolean eventMeshServerSecurityEnable = false;
    public boolean eventMeshServerRegistryEnable = false;
    public boolean eventMeshServerTraceEnable = false;
    protected ConfigurationWrapper configurationWrapper;
    public String eventMeshWebhookOrigin = "eventmesh." + this.eventMeshIDC;

    public CommonConfiguration(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public void init() {
        if (this.configurationWrapper != null) {
            this.eventMeshEnv = this.checkNotEmpty("eventMesh.server.env");
            this.sysID = this.checkNumeric("eventMesh.sysid");
            this.eventMeshCluster = this.checkNotEmpty("eventMesh.server.cluster");
            this.eventMeshName = this.checkNotEmpty("eventMesh.server.name");
            this.eventMeshIDC = this.checkNotEmpty("eventMesh.server.idc");
            this.eventMeshServerIp = this.get("eventMesh.server.hostIp", IPUtils::getLocalAddress);
            this.eventMeshConnectorPluginType = this.checkNotEmpty("eventMesh.connector.plugin.type");
            this.eventMeshServerSecurityEnable = Boolean.parseBoolean(this.get("eventMesh.server.security.enabled", () -> "false"));
            this.eventMeshSecurityPluginType = this.checkNotEmpty("eventMesh.security.plugin.type");
            this.eventMeshServerRegistryEnable = Boolean.parseBoolean(this.get("eventMesh.registry.plugin.enabled", () -> "false"));
            this.eventMeshRegistryPluginType = this.checkNotEmpty("eventMesh.registry.plugin.type");
            this.namesrvAddr = this.checkNotEmpty("eventMesh.registry.plugin.server-addr");
            this.eventMeshRegistryPluginUsername = Optional.ofNullable(this.configurationWrapper.getProp("eventMesh.registry.plugin.username")).orElse("");
            this.eventMeshRegistryPluginPassword = Optional.ofNullable(this.configurationWrapper.getProp("eventMesh.registry.plugin.password")).orElse("");
            String metricsPluginType = this.configurationWrapper.getProp("eventMesh.metrics.plugin");
            if (StringUtils.isNotEmpty((CharSequence)metricsPluginType)) {
                this.eventMeshMetricsPluginType = Arrays.stream(metricsPluginType.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
            }
            this.eventMeshServerTraceEnable = Boolean.parseBoolean(this.get("eventMesh.server.trace.enabled", () -> "false"));
            if (this.eventMeshServerTraceEnable) {
                this.eventMeshTracePluginType = this.checkNotEmpty("eventMesh.trace.plugin");
            }
        }
    }

    private String checkNotEmpty(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)value), (Object)(key + " is invalidated"));
        return value;
    }

    private String checkNumeric(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)value) && StringUtils.isNumeric((CharSequence)value) ? 1 : 0) != 0, (Object)(key + " is invalidated"));
        return value;
    }

    private String get(String key, Supplier<String> defaultValueSupplier) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        return StringUtils.isEmpty((CharSequence)value) ? defaultValueSupplier.get() : value;
    }

    public ConfigurationWrapper getConfigurationWrapper() {
        return this.configurationWrapper;
    }

    static class ConfKeys {
        public static final String KEYS_EVENTMESH_ENV = "eventMesh.server.env";
        public static final String KEYS_EVENTMESH_IDC = "eventMesh.server.idc";
        public static final String KEYS_EVENTMESH_SYSID = "eventMesh.sysid";
        public static final String KEYS_EVENTMESH_SERVER_CLUSTER = "eventMesh.server.cluster";
        public static final String KEYS_EVENTMESH_SERVER_NAME = "eventMesh.server.name";
        public static final String KEYS_EVENTMESH_SERVER_HOST_IP = "eventMesh.server.hostIp";
        public static final String KEYS_EVENTMESH_SERVER_REGISTER_INTERVAL = "eventMesh.server.registry.registerIntervalInMills";
        public static final String KEYS_EVENTMESH_SERVER_FETCH_REGISTRY_ADDR_INTERVAL = "eventMesh.server.registry.fetchRegistryAddrIntervalInMills";
        public static final String KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE = "eventMesh.connector.plugin.type";
        public static final String KEYS_EVENTMESH_SECURITY_ENABLED = "eventMesh.server.security.enabled";
        public static final String KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE = "eventMesh.security.plugin.type";
        public static final String KEYS_EVENTMESH_REGISTRY_ENABLED = "eventMesh.registry.plugin.enabled";
        public static final String KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE = "eventMesh.registry.plugin.type";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_SERVER_ADDR = "eventMesh.registry.plugin.server-addr";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_USERNAME = "eventMesh.registry.plugin.username";
        public static final String KEYS_EVENTMESH_REGISTRY_PULGIN_PASSWORD = "eventMesh.registry.plugin.password";
        public static final String KEYS_EVENTMESH_METRICS_PLUGIN_TYPE = "eventMesh.metrics.plugin";
        public static final String KEYS_EVENTMESH_TRACE_ENABLED = "eventMesh.server.trace.enabled";
        public static final String KEYS_EVENTMESH_TRACE_PLUGIN_TYPE = "eventMesh.trace.plugin";

        ConfKeys() {
        }
    }
}

