/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.nativejava;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.utils.Assert;

public class NativeJavaObjectOutput
implements ObjectOutput {
    private final ObjectOutputStream outputStream;

    public NativeJavaObjectOutput(OutputStream os) throws IOException {
        this(new ObjectOutputStream(os));
    }

    protected NativeJavaObjectOutput(ObjectOutputStream out) {
        Assert.notNull((Object)out, (String)"output == null");
        this.outputStream = out;
    }

    protected ObjectOutputStream getObjectOutputStream() {
        return this.outputStream;
    }

    public void writeObject(Object obj) throws IOException {
        this.outputStream.writeObject(obj);
    }

    public void writeBool(boolean v) throws IOException {
        this.outputStream.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.outputStream.writeByte(v);
    }

    public void writeShort(short v) throws IOException {
        this.outputStream.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.outputStream.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.outputStream.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.outputStream.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.outputStream.writeDouble(v);
    }

    public void writeUTF(String v) throws IOException {
        this.outputStream.writeUTF(v);
    }

    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.outputStream.writeInt(-1);
        } else {
            this.writeBytes(v, 0, v.length);
        }
    }

    public void writeBytes(byte[] v, int off, int len) throws IOException {
        if (v == null) {
            this.outputStream.writeInt(-1);
        } else {
            this.outputStream.writeInt(len);
            this.outputStream.write(v, off, len);
        }
    }

    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }
}

