/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.resource.GlobalResourcesRepository;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AdaptiveMetrics;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(group={"consumer"}, order=-200000, value={"loadbalance:adaptive"})
public class AdaptiveLoadBalanceFilter
implements Filter,
BaseFilter.Listener {
    private volatile ThreadPoolExecutor executor = null;
    private AdaptiveMetrics adaptiveMetrics;

    public AdaptiveLoadBalanceFilter(ApplicationModel scopeModel) {
        this.adaptiveMetrics = (AdaptiveMetrics)scopeModel.getBeanFactory().getBean(AdaptiveMetrics.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getExecutor() {
        if (null == this.executor) {
            AdaptiveLoadBalanceFilter adaptiveLoadBalanceFilter = this;
            synchronized (adaptiveLoadBalanceFilter) {
                if (null == this.executor) {
                    this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)new NamedInternalThreadFactory("Dubbo-framework-loadbalance-adaptive", true), new ThreadPoolExecutor.DiscardOldestPolicy());
                    GlobalResourcesRepository.getInstance().registerDisposable(() -> this.executor.shutdown());
                }
            }
        }
        return this.executor;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    private String buildServiceKey(Invocation invocation) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(invocation.getInvoker().getUrl().getAddress()).append(":").append(invocation.getProtocolServiceKey());
        return sb.toString();
    }

    private String getServiceKey(Invocation invocation) {
        String key = (String)invocation.getAttributes().get(invocation.getInvoker());
        if (StringUtils.isNotEmpty((String)key)) {
            return key;
        }
        key = this.buildServiceKey(invocation);
        invocation.getAttributes().put(invocation.getInvoker(), key);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        try {
            String loadBalance = (String)invocation.getAttributes().get("loadbalance");
            if (StringUtils.isEmpty((String)loadBalance) || !"adaptive".equals(loadBalance)) {
                return;
            }
            this.adaptiveMetrics.addConsumerSuccess(this.getServiceKey(invocation));
            String attachment = appResponse.getAttachment("lb_adaptive");
            if (StringUtils.isNotEmpty((String)attachment)) {
                String[] parties = CommonConstants.COMMA_SPLIT_PATTERN.split(attachment);
                if (parties.length == 0) {
                    return;
                }
                HashMap<String, String> metricsMap = new HashMap<String, String>();
                for (String party : parties) {
                    String[] groups = party.split(":");
                    if (groups.length != 2) continue;
                    metricsMap.put(groups[0], groups[1]);
                }
                Long startTime = (Long)invocation.getAttributes().get("adaptive_startTime");
                if (null != startTime) {
                    metricsMap.put("rt", String.valueOf(System.currentTimeMillis() - startTime));
                }
                this.getExecutor().execute(() -> this.adaptiveMetrics.setProviderMetrics(this.getServiceKey(invocation), metricsMap));
            }
        }
        finally {
            appResponse.getAttachments().remove("lb_adaptive");
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        String loadBalance = (String)invocation.getAttributes().get("loadbalance");
        if (StringUtils.isNotEmpty((String)loadBalance) && "adaptive".equals(loadBalance)) {
            this.getExecutor().execute(() -> this.adaptiveMetrics.addErrorReq(this.getServiceKey(invocation)));
        }
    }
}

