/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.StringUtils;

public class AdaptiveMetrics {
    private ConcurrentMap<String, AdaptiveMetrics> metricsStatistics = new ConcurrentHashMap<String, AdaptiveMetrics>();
    private long currentProviderTime = 0L;
    private double providerCPULoad = 0.0;
    private long lastLatency = 0L;
    private long currentTime = 0L;
    private long pickTime = System.currentTimeMillis();
    private double beta = 0.5;
    private final AtomicLong consumerReq = new AtomicLong();
    private final AtomicLong consumerSuccess = new AtomicLong();
    private final AtomicLong errorReq = new AtomicLong();
    private double ewma = 0.0;

    public double getLoad(String idKey, int weight, int timeout) {
        long multiple;
        AdaptiveMetrics metrics = this.getStatus(idKey);
        if (System.currentTimeMillis() - metrics.pickTime > (long)(timeout * 2)) {
            return 0.0;
        }
        if (metrics.currentTime > 0L && (multiple = (System.currentTimeMillis() - metrics.currentTime) / (long)timeout + 1L) > 0L) {
            metrics.lastLatency = metrics.currentProviderTime == metrics.currentTime ? (long)timeout * 2L : (metrics.lastLatency >>= (int)multiple);
            metrics.ewma = metrics.beta * metrics.ewma + (1.0 - metrics.beta) * (double)metrics.lastLatency;
            metrics.currentTime = System.currentTimeMillis();
        }
        long inflight = metrics.consumerReq.get() - metrics.consumerSuccess.get() - metrics.errorReq.get();
        return metrics.providerCPULoad * (Math.sqrt(metrics.ewma) + 1.0) * (double)(inflight + 1L) / ((double)metrics.consumerSuccess.get() / (double)(metrics.consumerReq.get() + 1L) * (double)weight + 1.0);
    }

    public AdaptiveMetrics getStatus(String idKey) {
        return this.metricsStatistics.computeIfAbsent(idKey, k -> new AdaptiveMetrics());
    }

    public void addConsumerReq(String idKey) {
        AdaptiveMetrics metrics = this.getStatus(idKey);
        metrics.consumerReq.incrementAndGet();
    }

    public void addConsumerSuccess(String idKey) {
        AdaptiveMetrics metrics = this.getStatus(idKey);
        metrics.consumerSuccess.incrementAndGet();
    }

    public void addErrorReq(String idKey) {
        AdaptiveMetrics metrics = this.getStatus(idKey);
        metrics.errorReq.incrementAndGet();
    }

    public void setPickTime(String idKey, long time) {
        AdaptiveMetrics metrics = this.getStatus(idKey);
        metrics.pickTime = time;
    }

    public void setProviderMetrics(String idKey, Map<String, String> metricsMap) {
        AdaptiveMetrics metrics = this.getStatus(idKey);
        long serviceTime = Long.parseLong(Optional.ofNullable(metricsMap.get("curTime")).filter(v -> StringUtils.isNumeric((String)v, (boolean)false)).orElse("0"));
        if (metrics.currentProviderTime > serviceTime) {
            return;
        }
        metrics.currentProviderTime = serviceTime;
        metrics.currentTime = serviceTime;
        metrics.providerCPULoad = Double.parseDouble(Optional.ofNullable(metricsMap.get("load")).filter(v -> StringUtils.isNumeric((String)v, (boolean)true)).orElse("0"));
        metrics.lastLatency = Long.parseLong(Optional.ofNullable(metricsMap.get("rt")).filter(v -> StringUtils.isNumeric((String)v, (boolean)false)).orElse("0"));
        metrics.beta = 0.5;
        metrics.ewma = metrics.beta * metrics.ewma + (1.0 - metrics.beta) * (double)metrics.lastLatency;
    }
}

