/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.registry.integration.ExporterFactory;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;

public class ReferenceCountExporter<T>
implements Exporter<T> {
    private final Exporter<T> exporter;
    private final String providerKey;
    private final ExporterFactory exporterFactory;
    private final AtomicInteger count = new AtomicInteger(0);

    public ReferenceCountExporter(Exporter<T> exporter, String providerKey, ExporterFactory exporterFactory) {
        this.exporter = exporter;
        this.providerKey = providerKey;
        this.exporterFactory = exporterFactory;
    }

    public Invoker<T> getInvoker() {
        return this.exporter.getInvoker();
    }

    public void increaseCount() {
        this.count.incrementAndGet();
    }

    public void unexport() {
        if (this.count.decrementAndGet() == 0) {
            this.exporter.unexport();
        }
        this.exporterFactory.remove(this.providerKey, this);
    }

    public void register() {
    }

    public void unregister() {
    }
}

