/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import org.apache.dubbo.config.spring.context.DubboBootstrapApplicationListener;
import org.apache.dubbo.config.spring.context.DubboLifecycleComponentApplicationListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.TypeUtils;

public class DubboApplicationListenerRegistrar
implements ApplicationContextAware {
    public static final String BEAN_NAME = "dubboApplicationListenerRegister";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!TypeUtils.isAssignable(ConfigurableApplicationContext.class, applicationContext.getClass())) {
            throw new IllegalArgumentException("The argument of ApplicationContext must be ConfigurableApplicationContext");
        }
        this.addApplicationListeners((ConfigurableApplicationContext)applicationContext);
    }

    private void addApplicationListeners(ConfigurableApplicationContext context) {
        context.addApplicationListener(this.createDubboBootstrapApplicationListener(context));
        context.addApplicationListener(this.createDubboLifecycleComponentApplicationListener(context));
    }

    private ApplicationListener<?> createDubboBootstrapApplicationListener(ConfigurableApplicationContext context) {
        return new DubboBootstrapApplicationListener((ApplicationContext)context);
    }

    private ApplicationListener<?> createDubboLifecycleComponentApplicationListener(ConfigurableApplicationContext context) {
        return new DubboLifecycleComponentApplicationListener((ApplicationContext)context);
    }
}

