/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.manager.DefaultExecutorRepository;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.executor.IsolationExecutorSupportFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class IsolationExecutorRepository
extends DefaultExecutorRepository {
    public IsolationExecutorRepository(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    @Override
    protected URL setThreadNameIfAbsent(URL url, String executorCacheKey) {
        if (url.getParameter("threadname") == null) {
            url = url.putAttribute("threadname", "isolation-" + executorCacheKey);
        }
        return url;
    }

    @Override
    protected String getProviderKey(URL url) {
        if (url.getAttributes().containsKey("service-executor")) {
            return url.getServiceKey();
        }
        return super.getProviderKey(url);
    }

    @Override
    protected ExecutorService createExecutor(URL url) {
        Object executor = url.getAttributes().get("service-executor");
        if (executor instanceof ExecutorService) {
            return (ExecutorService)executor;
        }
        return super.createExecutor(url);
    }

    @Override
    public ExecutorSupport getExecutorSupport(URL url) {
        return IsolationExecutorSupportFactory.getIsolationExecutorSupport(url);
    }
}

