/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.util.LdapURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReferenceCodec
extends LdapMessageCodec {
    private List<LdapURL> searchResultReferences = new ArrayList<LdapURL>();
    private int searchResultReferenceLength;

    @Override
    public int getMessageType() {
        return 18;
    }

    public void addSearchResultReference(LdapURL searchResultReference) {
        this.searchResultReferences.add(searchResultReference);
    }

    public List<LdapURL> getSearchResultReferences() {
        return this.searchResultReferences;
    }

    @Override
    public int computeLength() {
        this.searchResultReferenceLength = 0;
        for (LdapURL url : this.searchResultReferences) {
            int ldapUrlLength = url.getNbBytes();
            this.searchResultReferenceLength += 1 + TLV.getNbBytes((int)ldapUrlLength) + ldapUrlLength;
        }
        return 1 + TLV.getNbBytes((int)this.searchResultReferenceLength) + this.searchResultReferenceLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)115);
            buffer.put(TLV.getBytes((int)this.searchResultReferenceLength));
            for (LdapURL reference : this.searchResultReferences) {
                Value.encode((ByteBuffer)buffer, (String)reference.getString());
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Reference\n");
        if (this.searchResultReferences == null || this.searchResultReferences.size() == 0) {
            sb.append("        No Reference\n");
        } else {
            sb.append("        References\n");
            for (LdapURL url : this.searchResultReferences) {
                sb.append("            '").append(url).append("'\n");
            }
        }
        return sb.toString();
    }
}

