/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Typed;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.util.ParameterizedTypeImpl;

@Typed
public class HierarchyDiscovery {
    private final Type type;
    private Map<Type, Class<?>> types;

    public HierarchyDiscovery(Type type) {
        this.type = type;
    }

    protected void add(Class<?> clazz, Type type) {
        this.types.put(type, clazz);
    }

    public Set<Type> getTypeClosure() {
        if (this.types == null) {
            this.init();
        }
        return new HashSet<Type>(this.types.keySet());
    }

    private void init() {
        this.types = new HashMap();
        try {
            this.discoverTypes(this.type);
        }
        catch (StackOverflowError e) {
            Logger logger = Logger.getLogger(HierarchyDiscovery.class.getName());
            logger.log(Level.WARNING, "type: " + this.type.toString(), e);
            Thread.dumpStack();
            throw e;
        }
    }

    public Type getResolvedType() {
        if (this.type instanceof Class) {
            Class clazz = (Class)this.type;
            return this.resolveType(clazz);
        }
        return this.type;
    }

    private void discoverTypes(Type type) {
        if (type != null) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                this.add(clazz, this.resolveType(clazz));
                this.discoverFromClass(clazz);
            } else {
                Type rawType;
                Class clazz = null;
                if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                    this.discoverFromClass((Class)rawType);
                    clazz = (Class)rawType;
                }
                this.add(clazz, type);
            }
        }
    }

    private Type resolveType(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(clazz, actualTypeParameters, clazz.getDeclaringClass());
            return parameterizedType;
        }
        return clazz;
    }

    private void discoverFromClass(Class<?> clazz) {
        this.discoverTypes(this.resolveType(this.type, this.type, clazz.getGenericSuperclass()));
        for (Type c : clazz.getGenericInterfaces()) {
            this.discoverTypes(this.resolveType(this.type, this.type, c));
        }
    }

    private Type resolveType(Type beanType, Type beanType2, Type type) {
        if (type instanceof ParameterizedType) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveParameterizedType((ParameterizedType)beanType, (ParameterizedType)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), beanType2, type);
            }
        }
        if (type instanceof TypeVariable) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveTypeParameter((ParameterizedType)beanType, beanType2, (TypeVariable)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), beanType2, type);
            }
        }
        return type;
    }

    private Type resolveParameterizedType(ParameterizedType beanType, ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypes = parameterizedType.getActualTypeArguments();
        Type resolvedRawType = this.resolveType(beanType, beanType, rawType);
        Type[] resolvedActualTypes = new Type[actualTypes.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            resolvedActualTypes[i] = this.resolveType(beanType, beanType, actualTypes[i]);
        }
        return new ParameterizedTypeImpl(resolvedRawType, resolvedActualTypes, parameterizedType.getOwnerType());
    }

    private Type resolveTypeParameter(ParameterizedType type, Type beanType, TypeVariable<?> typeVariable) {
        Class actualType = (Class)type.getRawType();
        TypeVariable<Class<T>>[] typeVariables = actualType.getTypeParameters();
        Type[] actualTypes = type.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            if (!typeVariables[i].equals(typeVariable) || actualTypes[i].equals(typeVariable)) continue;
            return this.resolveType(this.type, beanType, actualTypes[i]);
        }
        Type genericSuperType = actualType.getGenericSuperclass();
        Type resolvedGenericSuperType = this.resolveType(genericSuperType, beanType, typeVariable);
        if (!(resolvedGenericSuperType instanceof TypeVariable)) {
            return resolvedGenericSuperType;
        }
        if (beanType instanceof ParameterizedType) {
            for (Type interfaceType : ((Class)((ParameterizedType)beanType).getRawType()).getGenericInterfaces()) {
                Type resolvedType = this.resolveType(interfaceType, interfaceType, typeVariable);
                if (resolvedType instanceof TypeVariable) continue;
                return resolvedType;
            }
        }
        return typeVariable;
    }
}

