/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.deltaspike.core.util.metadata.builder.ImmutableInjectionPoint;

@Typed
public abstract class BeanUtils {
    private BeanUtils() {
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Annotation[] ... annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        Annotation[][] annotationArray = annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotationArray2;
            for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    public static <T extends Annotation> T extractAnnotation(Annotated annotated, Class<T> targetType) {
        Annotation result;
        block1: {
            Annotation annotation;
            result = annotated.getAnnotation(targetType);
            if (result != null) break block1;
            Iterator iterator = annotated.getAnnotations().iterator();
            while (iterator.hasNext() && (result = (annotation = (Annotation)iterator.next()).annotationType().getAnnotation(targetType)) == null) {
            }
        }
        return (T)result;
    }

    public static <X> List<InjectionPoint> createInjectionPoints(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (AnnotatedParameter parameter : method.getParameters()) {
            ImmutableInjectionPoint injectionPoint = new ImmutableInjectionPoint(parameter, beanManager, declaringBean, false, false);
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

