/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.exception.control;

import jakarta.enterprise.inject.Typed;
import java.io.Serializable;
import java.util.Arrays;

@Typed
public final class ExceptionStackItem
implements Serializable {
    private static final long serialVersionUID = 5162936095781886477L;
    private final Throwable throwable;
    private final StackTraceElement[] stackTraceElements;

    public ExceptionStackItem(Throwable cause) {
        this(cause, cause.getStackTrace());
    }

    public ExceptionStackItem(Throwable throwable, StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = (StackTraceElement[])stackTraceElements.clone();
        this.throwable = throwable;
    }

    public StackTraceElement[] getStackTraceElements() {
        return (StackTraceElement[])this.stackTraceElements.clone();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "throwable: " + this.throwable + ", " + "stackTraceElements: " + Arrays.toString(this.stackTraceElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionStackItem that = (ExceptionStackItem)o;
        if (!Arrays.equals(this.stackTraceElements, that.stackTraceElements)) {
            return false;
        }
        return this.throwable.equals(that.throwable);
    }

    public int hashCode() {
        int result = this.throwable.hashCode();
        result = 31 * result + Arrays.hashCode(this.stackTraceElements);
        return result;
    }
}

