/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config.view.metadata;

import jakarta.inject.Named;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.api.config.view.metadata.DefaultCallback;
import org.apache.deltaspike.core.api.provider.BeanProvider;

public abstract class CallbackDescriptor {
    protected List<CallbackEntry> callbacks = new ArrayList<CallbackEntry>();
    protected Class<? extends Annotation> callbackType;

    protected CallbackDescriptor(Class<?> beanClass, Class<? extends Annotation> callbackMarker) {
        this.init(new Class[]{beanClass}, callbackMarker);
    }

    protected CallbackDescriptor(Class<?>[] beanClasses, Class<? extends Annotation> callbackMarker) {
        this.init(beanClasses, callbackMarker);
    }

    protected void init(Class<?>[] targetBeanClasses, Class<? extends Annotation> callbackMarker) {
        if (callbackMarker == null) {
            callbackMarker = DefaultCallback.class;
        }
        this.callbackType = callbackMarker;
        for (Class<?> targetBeanClass : targetBeanClasses) {
            CallbackEntry callbackEntry = new CallbackEntry(targetBeanClass, callbackMarker);
            if (callbackEntry.callbackMethods.isEmpty()) continue;
            this.callbacks.add(callbackEntry);
        }
    }

    public Map<Class<?>, List<Method>> getCallbackMethods() {
        HashMap result = new HashMap(this.callbacks.size());
        for (CallbackEntry callbackEntry : this.callbacks) {
            result.put(callbackEntry.targetBeanClass, new ArrayList(callbackEntry.callbackMethods));
        }
        return result;
    }

    protected <T> T getTargetObject(Class<T> targetType) {
        return BeanProvider.getContextualReference(targetType, true, new Annotation[0]);
    }

    protected Object getTargetObjectByName(String beanName) {
        return BeanProvider.getContextualReference(beanName, true);
    }

    public boolean isBoundTo(Class<? extends Annotation> callbackType) {
        return this.callbackType.equals(callbackType);
    }

    protected static class CallbackEntry {
        private List<Method> callbackMethods = new ArrayList<Method>();
        private final Class<?> targetBeanClass;
        private final String beanName;

        private CallbackEntry(Class<?> beanClass, Class<? extends Annotation> callbackMarker) {
            this.targetBeanClass = beanClass;
            Named named = this.targetBeanClass.getAnnotation(Named.class);
            this.beanName = named != null && !"".equals(named.value()) ? named.value() : Introspector.decapitalize(this.targetBeanClass.getSimpleName());
            ArrayList<String> processedMethodNames = new ArrayList<String>();
            this.findMethodWithCallbackMarker(callbackMarker, beanClass, processedMethodNames);
        }

        private void findMethodWithCallbackMarker(Class<? extends Annotation> callbackMarker, Class<?> classToAnalyze, List<String> processedMethodNames) {
            for (Class<?> currentClass = classToAnalyze; currentClass != null && !Object.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
                for (Method method : currentClass.getDeclaredMethods()) {
                    if (processedMethodNames.contains(method.getName()) || !method.isAnnotationPresent(callbackMarker)) continue;
                    processedMethodNames.add(method.getName());
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalStateException("Private methods aren't supported to avoid side-effects with normal-scoped CDI beans. Please use e.g. protected or public instead. ");
                    }
                    method.setAccessible(true);
                    this.callbackMethods.add(method);
                }
                for (GenericDeclaration genericDeclaration : currentClass.getInterfaces()) {
                    this.findMethodWithCallbackMarker(callbackMarker, (Class<?>)genericDeclaration, processedMethodNames);
                }
            }
        }

        public List<Method> getCallbackMethods() {
            return this.callbackMethods;
        }

        public Class<?> getTargetBeanClass() {
            return this.targetBeanClass;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

