/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.sts.provider;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBContextCache;
import org.apache.cxf.ws.security.sts.provider.model.ObjectFactory;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.CancelOperation;
import org.apache.cxf.ws.security.sts.provider.operation.IssueOperation;
import org.apache.cxf.ws.security.sts.provider.operation.KeyExchangeTokenOperation;
import org.apache.cxf.ws.security.sts.provider.operation.RenewOperation;
import org.apache.cxf.ws.security.sts.provider.operation.RequestCollectionOperation;
import org.apache.cxf.ws.security.sts.provider.operation.ValidateOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceMode(value=Service.Mode.PAYLOAD)
public class SecurityTokenServiceProvider
implements Provider<Source> {
    private static final String WSTRUST_13_NAMESPACE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private static final String WSTRUST_REQUESTTYPE_ELEMENTNAME = "RequestType";
    private static final String WSTRUST_REQUESTTYPE_ISSUE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
    private static final String WSTRUST_REQUESTTYPE_CANCEL = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel";
    private static final String WSTRUST_REQUESTTYPE_RENEW = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew";
    private static final String WSTRUST_REQUESTTYPE_VALIDATE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate";
    private static final String WSTRUST_REQUESTTYPE_REQUESTCOLLECTION = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RequestCollection";
    private static final String WSTRUST_REQUESTTYPE_KEYEXCHANGETOKEN = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/KeyExchangeToken";
    private static final Map<String, Method> OPERATION_METHODS = new HashMap<String, Method>();
    protected JAXBContext jaxbContext;
    protected Set<Class<?>> jaxbContextClasses;
    protected SOAPFactory soapFactory;
    private CancelOperation cancelOperation;
    private IssueOperation issueOperation;
    private KeyExchangeTokenOperation keyExchangeTokenOperation;
    private RenewOperation renewOperation;
    private RequestCollectionOperation requestCollectionOperation;
    private ValidateOperation validateOperation;
    private Map<String, Object> operationMap = new HashMap<String, Object>();
    @Resource
    private WebServiceContext context;

    public SecurityTokenServiceProvider() throws Exception {
        JAXBContextCache.CachedContextAndSchemas cache = JAXBContextCache.getCachedContextAndSchemas(ObjectFactory.class);
        this.jaxbContext = cache.getContext();
        this.jaxbContextClasses = cache.getClasses();
        this.soapFactory = SAAJFactoryResolver.createSOAPFactory(null);
    }

    public void setCancelOperation(CancelOperation cancelOperation) {
        this.cancelOperation = cancelOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_CANCEL, cancelOperation);
    }

    public void setIssueOperation(IssueOperation issueOperation) {
        this.issueOperation = issueOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_ISSUE, issueOperation);
    }

    public void setKeyExchangeTokenOperation(KeyExchangeTokenOperation keyExchangeTokenOperation) {
        this.keyExchangeTokenOperation = keyExchangeTokenOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_KEYEXCHANGETOKEN, keyExchangeTokenOperation);
    }

    public void setRenewOperation(RenewOperation renewOperation) {
        this.renewOperation = renewOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_RENEW, renewOperation);
    }

    public void setRequestCollectionOperation(RequestCollectionOperation requestCollectionOperation) {
        this.requestCollectionOperation = requestCollectionOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_REQUESTCOLLECTION, requestCollectionOperation);
    }

    public void setValidateOperation(ValidateOperation validateOperation) {
        this.validateOperation = validateOperation;
        this.operationMap.put(WSTRUST_REQUESTTYPE_VALIDATE, validateOperation);
    }

    public Source invoke(Source request) {
        JAXBSource response = null;
        try {
            Object tokenResponse;
            Object obj = this.convertToJAXBObject(request);
            Object operationImpl = null;
            Method method = null;
            if (obj instanceof RequestSecurityTokenCollectionType) {
                operationImpl = this.operationMap.get(WSTRUST_REQUESTTYPE_REQUESTCOLLECTION);
                method = OPERATION_METHODS.get(WSTRUST_REQUESTTYPE_REQUESTCOLLECTION);
            } else {
                RequestSecurityTokenType rst = (RequestSecurityTokenType)obj;
                List<Object> objectList = rst.getAny();
                for (Object o : objectList) {
                    QName qname;
                    if (!(o instanceof JAXBElement) || !(qname = ((JAXBElement)o).getName()).equals(new QName(WSTRUST_13_NAMESPACE, WSTRUST_REQUESTTYPE_ELEMENTNAME))) continue;
                    String val = ((JAXBElement)o).getValue().toString();
                    operationImpl = this.operationMap.get(val);
                    method = OPERATION_METHODS.get(val);
                    break;
                }
            }
            if (operationImpl == null || method == null) {
                throw new Exception("Implementation for this operation not found.");
            }
            if ((obj = method.invoke(operationImpl, obj, this.context)) == null) {
                throw new Exception("Error in implementation class.");
            }
            if (obj instanceof RequestSecurityTokenResponseCollectionType) {
                tokenResponse = (RequestSecurityTokenResponseCollectionType)obj;
                response = new JAXBSource(this.jaxbContext, new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)tokenResponse));
            } else {
                tokenResponse = (RequestSecurityTokenResponseType)obj;
                response = new JAXBSource(this.jaxbContext, new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)tokenResponse));
            }
        }
        catch (Exception e) {
            try {
                SOAPFault fault = this.soapFactory.createFault();
                if (e.getMessage() == null) {
                    fault.setFaultString(e.getCause().getMessage());
                } else {
                    fault.setFaultString(e.getMessage());
                }
                Detail detail = fault.addDetail();
                detail = fault.getDetail();
                QName qName = new QName(WSTRUST_13_NAMESPACE, "Fault", "ns");
                DetailEntry de = detail.addDetailEntry(qName);
                qName = new QName(WSTRUST_13_NAMESPACE, "ErrorCode", "ns");
                SOAPElement errorElement = de.addChildElement(qName);
                StackTraceElement[] ste = e.getStackTrace();
                errorElement.setTextContent(ste[0].toString());
                throw new SOAPFaultException(fault);
            }
            catch (SOAPException e1) {
                throw new Fault((Throwable)e1);
            }
        }
        return response;
    }

    private Object convertToJAXBObject(Source source) throws Exception {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(source);
        return jaxbElement.getValue();
    }

    public CancelOperation getCancelOperation() {
        return this.cancelOperation;
    }

    public IssueOperation getIssueOperation() {
        return this.issueOperation;
    }

    public KeyExchangeTokenOperation getKeyExchangeTokenOperation() {
        return this.keyExchangeTokenOperation;
    }

    public RenewOperation getRenewOperation() {
        return this.renewOperation;
    }

    public RequestCollectionOperation getRequestCollectionOperation() {
        return this.requestCollectionOperation;
    }

    public ValidateOperation getValidateOperation() {
        return this.validateOperation;
    }

    static {
        try {
            Method m = IssueOperation.class.getDeclaredMethod("issue", RequestSecurityTokenType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_ISSUE, m);
            m = IssueOperation.class.getDeclaredMethod("cancel", RequestSecurityTokenType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_CANCEL, m);
            m = IssueOperation.class.getDeclaredMethod("renew", RequestSecurityTokenType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_RENEW, m);
            m = IssueOperation.class.getDeclaredMethod("validate", RequestSecurityTokenType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_VALIDATE, m);
            m = IssueOperation.class.getDeclaredMethod("keyExchangeToken", RequestSecurityTokenType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_KEYEXCHANGETOKEN, m);
            m = IssueOperation.class.getDeclaredMethod("requestCollection", RequestSecurityTokenCollectionType.class, WebServiceContext.class);
            OPERATION_METHODS.put(WSTRUST_REQUESTTYPE_REQUESTCOLLECTION, m);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

