/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutBuilder
implements AssertionBuilder<Element> {
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.LAYOUT, SP12Constants.LAYOUT};

    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        Layout layout = new Layout(consts);
        this.processAlternative(element, layout, consts);
        return layout;
    }

    public void processAlternative(Element element, Layout parent, SPConstants consts) {
        Element child;
        Element polEl = PolicyConstants.findPolicyElement((Element)element);
        if (polEl != null && (child = DOMUtils.getFirstElement((Node)polEl)) != null) {
            parent.setValue(SPConstants.Layout.valueOf(child.getLocalName()));
        }
    }
}

