/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;

public class FieldTypeDouble
extends AbstractFieldType {
    public FieldTypeDouble(int type, String name) {
        super(type, name, 8);
    }

    @Override
    public Object getValue(TiffField entry) {
        byte[] bytes = entry.getByteArrayValue();
        if (entry.getCount() == 1L) {
            return ByteConversions.toDouble(bytes, entry.getByteOrder());
        }
        return ByteConversions.toDoubles(bytes, entry.getByteOrder());
    }

    @Override
    public byte[] writeData(Object o, ByteOrder byteOrder) throws ImagingException {
        if (o instanceof Double) {
            return ByteConversions.toBytes((Double)o, byteOrder);
        }
        if (o instanceof double[]) {
            return ByteConversions.toBytes((double[])o, byteOrder);
        }
        if (!(o instanceof Double[])) {
            throw new ImagingException("Invalid data", o);
        }
        double[] values = Allocator.doubleArray(((Double[])o).length);
        Arrays.setAll(values, i -> ((Double[])o)[i]);
        return ByteConversions.toBytes(values, byteOrder);
    }
}

