/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.AbstractColumnFamilyOutputFormat;
import org.apache.cassandra.hadoop.AbstractColumnFamilyRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlOutputFormat;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CqlRecordWriter
extends AbstractColumnFamilyRecordWriter<Map<String, ByteBuffer>, List<ByteBuffer>> {
    private static final Logger logger = LoggerFactory.getLogger(CqlRecordWriter.class);
    private final Map<InetAddress, RangeClient> clients;
    private ConcurrentHashMap<Cassandra.Client, Integer> preparedStatements = new ConcurrentHashMap();
    private final String cql;
    private AbstractType<?> keyValidator;
    private String[] partitionKeyColumns;
    private List<String> clusterColumns;

    CqlRecordWriter(TaskAttemptContext context) throws IOException {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
    }

    CqlRecordWriter(Configuration conf, Progressable progressable) throws IOException {
        this(conf);
        this.progressable = progressable;
    }

    CqlRecordWriter(Configuration conf) {
        super(conf);
        this.clients = new HashMap<InetAddress, RangeClient>();
        try {
            TTransport transport;
            Cassandra.Client client = ConfigHelper.getClientFromOutputAddressList(conf);
            client.set_keyspace(ConfigHelper.getOutputKeyspace(conf));
            String user = ConfigHelper.getOutputKeyspaceUserName(conf);
            String password = ConfigHelper.getOutputKeyspacePassword(conf);
            if (user != null && password != null) {
                AbstractColumnFamilyOutputFormat.login(user, password, client);
            }
            this.retrievePartitionKeyValidator(client);
            String cqlQuery = CqlConfigHelper.getOutputCql(conf).trim();
            if (cqlQuery.toLowerCase().startsWith("insert")) {
                throw new UnsupportedOperationException("INSERT with CqlRecordWriter is not supported, please use UPDATE/DELETE statement");
            }
            this.cql = this.appendKeyWhereClauses(cqlQuery);
            if (client != null && (transport = client.getOutputProtocol().getTransport()).isOpen()) {
                transport.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        IOException clientException = null;
        for (RangeClient client : this.clients.values()) {
            try {
                client.close();
            }
            catch (IOException e) {
                clientException = e;
            }
        }
        if (clientException != null) {
            throw clientException;
        }
    }

    public void write(Map<String, ByteBuffer> keyColumns, List<ByteBuffer> values) throws IOException {
        Range<Token> range = this.ringCache.getRange(this.getPartitionKey(keyColumns));
        InetAddress address = this.ringCache.getEndpoint(range).get(0);
        RangeClient client = this.clients.get(address);
        if (client == null) {
            client = new RangeClient(this.ringCache.getEndpoint(range));
            client.start();
            this.clients.put(address, client);
        }
        ArrayList<ByteBuffer> allValues = new ArrayList<ByteBuffer>(values);
        for (String column : this.partitionKeyColumns) {
            allValues.add(keyColumns.get(column));
        }
        for (String column : this.clusterColumns) {
            allValues.add(keyColumns.get(column));
        }
        client.put(allValues);
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if (this.context != null) {
            HadoopCompat.progress(this.context);
        }
    }

    private ByteBuffer getPartitionKey(Map<String, ByteBuffer> keyColumns) {
        ByteBuffer partitionKey;
        if (this.keyValidator instanceof CompositeType) {
            ByteBuffer[] keys = new ByteBuffer[this.partitionKeyColumns.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = keyColumns.get(this.partitionKeyColumns[i]);
            }
            partitionKey = CompositeType.build(keys);
        } else {
            partitionKey = keyColumns.get(this.partitionKeyColumns[0]);
        }
        return partitionKey;
    }

    private void retrievePartitionKeyValidator(Cassandra.Client client) throws Exception {
        String keyspace = ConfigHelper.getOutputKeyspace(this.conf);
        String cfName = ConfigHelper.getOutputColumnFamily(this.conf);
        String query = "SELECT key_validator,       key_aliases,       column_aliases FROM system.schema_columnfamilies WHERE keyspace_name='%s' and columnfamily_name='%s'";
        String formatted = String.format(query, keyspace, cfName);
        CqlResult result = client.execute_cql3_query(ByteBufferUtil.bytes(formatted), Compression.NONE, ConsistencyLevel.ONE);
        Column rawKeyValidator = (Column)((CqlRow)result.rows.get((int)0)).columns.get(0);
        String validator = ByteBufferUtil.string(ByteBuffer.wrap(rawKeyValidator.getValue()));
        this.keyValidator = this.parseType(validator);
        Column rawPartitionKeys = (Column)((CqlRow)result.rows.get((int)0)).columns.get(1);
        String keyString = ByteBufferUtil.string(ByteBuffer.wrap(rawPartitionKeys.getValue()));
        logger.debug("partition keys: " + keyString);
        List<String> keys = FBUtilities.fromJsonList(keyString);
        this.partitionKeyColumns = new String[keys.size()];
        int i = 0;
        Iterator<String> i$ = keys.iterator();
        while (i$.hasNext()) {
            String key;
            this.partitionKeyColumns[i] = key = i$.next();
            ++i;
        }
        Column rawClusterColumns = (Column)((CqlRow)result.rows.get((int)0)).columns.get(2);
        String clusterColumnString = ByteBufferUtil.string(ByteBuffer.wrap(rawClusterColumns.getValue()));
        logger.debug("cluster columns: " + clusterColumnString);
        this.clusterColumns = FBUtilities.fromJsonList(clusterColumnString);
    }

    private AbstractType<?> parseType(String type) throws ConfigurationException {
        try {
            if (type != null && type.equals("org.apache.cassandra.db.marshal.CounterColumnType")) {
                return LongType.instance;
            }
            return TypeParser.parse(type);
        }
        catch (SyntaxException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private String appendKeyWhereClauses(String cqlQuery) {
        String keyWhereClause = "";
        for (String partitionKey : this.partitionKeyColumns) {
            keyWhereClause = keyWhereClause + String.format("%s = ?", keyWhereClause.isEmpty() ? this.quote(partitionKey) : " AND " + this.quote(partitionKey));
        }
        for (String clusterColumn : this.clusterColumns) {
            keyWhereClause = keyWhereClause + " AND " + this.quote(clusterColumn) + " = ?";
        }
        return cqlQuery + " WHERE " + keyWhereClause;
    }

    private String quote(String identifier) {
        return "\"" + identifier.replaceAll("\"", "\"\"") + "\"";
    }

    static /* synthetic */ long access$000(CqlRecordWriter x0) {
        return x0.batchThreshold;
    }

    static /* synthetic */ Configuration access$100(CqlRecordWriter x0) {
        return x0.conf;
    }

    static /* synthetic */ Configuration access$200(CqlRecordWriter x0) {
        return x0.conf;
    }

    public class RangeClient
    extends AbstractColumnFamilyRecordWriter.AbstractRangeClient<List<ByteBuffer>> {
        public RangeClient(List<InetAddress> endpoints) {
            super(endpoints);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block6: while (this.run || !this.queue.isEmpty()) {
                try {
                    bindVariables = (List)this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                iter = this.endpoints.iterator();
                while (true) {
                    try {
                        i = 0;
                        itemId = this.preparedStatement(this.client);
                        while (bindVariables != null) {
                            this.client.execute_prepared_cql3_query(itemId, bindVariables, ConsistencyLevel.ONE);
                            if ((long)(++i) >= CqlRecordWriter.access$000(CqlRecordWriter.this)) continue block6;
                            bindVariables = (List)this.queue.poll();
                        }
                        continue block6;
                    }
                    catch (Exception e) {
                        this.closeInternal();
                        if (!iter.hasNext()) {
                            this.lastException = new IOException(e);
                            break block6;
                        }
                        try {
                            address = (InetAddress)iter.next();
                            host = address.getHostName();
                            port = ConfigHelper.getOutputRpcPort(CqlRecordWriter.access$100(CqlRecordWriter.this));
                            this.client = CqlOutputFormat.createAuthenticatedClient(host, port, CqlRecordWriter.access$200(CqlRecordWriter.this));
                            continue;
                        }
                        catch (Exception e) {
                            this.closeInternal();
                            if (!(e instanceof TException) || !iter.hasNext()) ** break;
                            continue;
                            this.lastException = new IOException(e);
                            break block6;
                        }
                    }
                    break;
                }
            }
            this.closeInternal();
        }

        private int preparedStatement(Cassandra.Client client) {
            Integer itemId = (Integer)CqlRecordWriter.this.preparedStatements.get(client);
            if (itemId == null) {
                CqlPreparedResult result;
                try {
                    result = client.prepare_cql3_query(ByteBufferUtil.bytes(CqlRecordWriter.this.cql), Compression.NONE);
                }
                catch (InvalidRequestException e) {
                    throw new RuntimeException("failed to prepare cql query " + CqlRecordWriter.this.cql, e);
                }
                catch (TException e) {
                    throw new RuntimeException("failed to prepare cql query " + CqlRecordWriter.this.cql, e);
                }
                Integer previousId = CqlRecordWriter.this.preparedStatements.putIfAbsent(client, result.itemId);
                itemId = previousId == null ? result.itemId : previousId;
            }
            return itemId;
        }
    }
}

