/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AbstractBulkOutputFormat<K, V>
extends OutputFormat<K, V>
implements org.apache.hadoop.mapred.OutputFormat<K, V> {
    public void checkOutputSpecs(JobContext context) {
        this.checkOutputSpecs(HadoopCompat.getConfiguration(context));
    }

    private void checkOutputSpecs(Configuration conf) {
        if (ConfigHelper.getOutputKeyspace(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace with setColumnFamily()");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    @Deprecated
    public void checkOutputSpecs(FileSystem filesystem, JobConf job) throws IOException {
        this.checkOutputSpecs((Configuration)job);
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

