/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Pair;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyLeveledManifest {
    private static final Logger logger = LoggerFactory.getLogger(LegacyLeveledManifest.class);
    private Map<Integer, Integer> sstableLevels = new HashMap<Integer, Integer>();

    private LegacyLeveledManifest(File path) throws IOException {
        ObjectMapper m = new ObjectMapper();
        JsonNode rootNode = (JsonNode)m.readValue(path, JsonNode.class);
        JsonNode generations = rootNode.get("generations");
        assert (generations.isArray());
        for (JsonNode generation : generations) {
            int level = generation.get("generation").getIntValue();
            JsonNode generationValues = generation.get("members");
            for (JsonNode generationValue : generationValues) {
                this.sstableLevels.put(generationValue.getIntValue(), level);
            }
        }
    }

    private int levelOf(int sstableGeneration) {
        return this.sstableLevels.containsKey(sstableGeneration) ? this.sstableLevels.get(sstableGeneration) : 0;
    }

    public static boolean manifestNeedsMigration(String keyspace, String columnFamily) {
        return Directories.create(keyspace, columnFamily).tryGetLeveledManifest() != null;
    }

    public static void migrateManifests(String keyspace, String columnFamily) throws IOException {
        logger.info("Migrating manifest for {}/{}", (Object)keyspace, (Object)columnFamily);
        LegacyLeveledManifest.snapshotWithoutCFS(keyspace, columnFamily);
        Directories directories = Directories.create(keyspace, columnFamily);
        File manifestFile = directories.tryGetLeveledManifest();
        if (manifestFile == null) {
            return;
        }
        LegacyLeveledManifest legacyManifest = new LegacyLeveledManifest(manifestFile);
        for (Map.Entry<Descriptor, Set<Component>> entry : directories.sstableLister().includeBackups(false).skipTemporary(true).list().entrySet()) {
            Descriptor d = entry.getKey();
            Pair<SSTableMetadata, Set<Integer>> oldMetadata = SSTableMetadata.serializer.deserialize(d, false);
            String metadataFilename = d.filenameFor(Component.STATS);
            LeveledManifest.mutateLevel(oldMetadata, d, metadataFilename, legacyManifest.levelOf(d.generation));
        }
        FileUtils.deleteWithConfirm(manifestFile);
    }

    public static void snapshotWithoutCFS(String keyspace, String columnFamily) throws IOException {
        Directories directories = Directories.create(keyspace, columnFamily);
        String snapshotName = "pre-sstablemetamigration";
        logger.info("Snapshotting {}, {} to {}", new Object[]{keyspace, columnFamily, snapshotName});
        for (Map.Entry<Descriptor, Set<Component>> entry : directories.sstableLister().includeBackups(false).skipTemporary(true).list().entrySet()) {
            Descriptor descriptor = entry.getKey();
            File snapshotDirectoryPath = Directories.getSnapshotDirectory(descriptor, snapshotName);
            for (Component component : entry.getValue()) {
                File sourceFile = new File(descriptor.filenameFor(component));
                File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
                FileUtils.createHardLink(sourceFile, targetLink);
            }
        }
        File manifestFile = directories.tryGetLeveledManifest();
        if (manifestFile != null) {
            File snapshotDirectory = new File(new File(manifestFile.getParentFile(), "snapshots"), snapshotName);
            if (!snapshotDirectory.exists()) {
                snapshotDirectory.mkdirs();
            }
            File target = new File(snapshotDirectory, manifestFile.getName());
            FileUtils.createHardLink(manifestFile, target);
        }
    }
}

