/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TreeMapBackedSortedColumns;
import org.apache.cassandra.db.UnsortedColumns;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.BatchRemoveIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.StreamingHistogram;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ColumnFamily
implements Iterable<Column>,
IRowCacheEntry {
    public static final ColumnFamilySerializer serializer = new ColumnFamilySerializer();
    protected final CFMetaData metadata;

    protected ColumnFamily(CFMetaData metadata) {
        assert (metadata != null);
        this.metadata = metadata;
    }

    public <T extends ColumnFamily> T cloneMeShallow(Factory<T> factory, boolean reversedInsertOrder) {
        T cf = factory.create(this.metadata, reversedInsertOrder);
        ((ColumnFamily)cf).delete(this);
        return cf;
    }

    public ColumnFamily cloneMeShallow() {
        return this.cloneMeShallow(false);
    }

    public ColumnFamily cloneMeShallow(boolean reversed) {
        return this.cloneMeShallow(this.getFactory(), reversed);
    }

    public ColumnFamilyType getType() {
        return this.metadata.cfType;
    }

    public abstract ColumnFamily cloneMe();

    public UUID id() {
        return this.metadata.cfId;
    }

    public CFMetaData metadata() {
        return this.metadata;
    }

    public void addIfRelevant(Column column, DeletionInfo.InOrderTester tester, int gcBefore) {
        if (column.getLocalDeletionTime() >= gcBefore && !tester.isDeleted(column.name(), column.timestamp())) {
            this.addColumn(column);
        }
    }

    public void addColumn(Column column) {
        this.addColumn(column, HeapAllocator.instance);
    }

    public void addColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        this.addColumn(name, value, timestamp, 0);
    }

    public void addColumn(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive) {
        assert (!this.metadata().getDefaultValidator().isCommutative());
        Column column = Column.create(name, value, timestamp, timeToLive, this.metadata());
        this.addColumn(column);
    }

    public void addCounter(ByteBuffer name, long value) {
        this.addColumn(new CounterUpdateColumn(name, value, System.currentTimeMillis()));
    }

    public void addTombstone(ByteBuffer name, ByteBuffer localDeletionTime, long timestamp) {
        this.addColumn(new DeletedColumn(name, localDeletionTime, timestamp));
    }

    public void addTombstone(ByteBuffer name, int localDeletionTime, long timestamp) {
        this.addColumn(new DeletedColumn(name, localDeletionTime, timestamp));
    }

    public void addAtom(OnDiskAtom atom) {
        if (atom instanceof Column) {
            this.addColumn((Column)atom);
        } else {
            assert (atom instanceof RangeTombstone);
            this.delete((RangeTombstone)atom);
        }
    }

    public abstract void clear();

    public DeletionInfo.InOrderTester inOrderDeletionTester() {
        return this.deletionInfo().inOrderTester();
    }

    public abstract Factory getFactory();

    public abstract DeletionInfo deletionInfo();

    public abstract void setDeletionInfo(DeletionInfo var1);

    public abstract void delete(DeletionInfo var1);

    public abstract void delete(DeletionTime var1);

    protected abstract void delete(RangeTombstone var1);

    public abstract void purgeTombstones(int var1);

    public abstract void addColumn(Column var1, Allocator var2);

    public abstract void addAll(ColumnFamily var1, Allocator var2, Function<Column, Column> var3);

    public abstract boolean replace(Column var1, Column var2);

    public abstract Column getColumn(ByteBuffer var1);

    public abstract Iterable<ByteBuffer> getColumnNames();

    public abstract Collection<Column> getSortedColumns();

    public abstract Collection<Column> getReverseSortedColumns();

    public abstract int getColumnCount();

    public boolean isEmpty() {
        return this.deletionInfo().isLive() && this.getColumnCount() == 0;
    }

    public abstract Iterator<Column> iterator(ColumnSlice[] var1);

    public abstract Iterator<Column> reverseIterator(ColumnSlice[] var1);

    public abstract boolean isInsertReversed();

    public void delete(ColumnFamily columns) {
        this.delete(columns.deletionInfo());
    }

    public void addAll(ColumnFamily cf, Allocator allocator) {
        this.addAll(cf, allocator, (Function<Column, Column>)Functions.identity());
    }

    public ColumnFamily diff(ColumnFamily cfComposite) {
        assert (cfComposite.id().equals(this.id()));
        TreeMapBackedSortedColumns cfDiff = TreeMapBackedSortedColumns.factory.create(this.metadata);
        ((ColumnFamily)cfDiff).delete(cfComposite.deletionInfo());
        for (Column columnExternal : cfComposite) {
            ByteBuffer cName = columnExternal.name();
            Column columnInternal = this.getColumn(cName);
            if (columnInternal == null) {
                cfDiff.addColumn(columnExternal);
                continue;
            }
            Column columnDiff = columnInternal.diff(columnExternal);
            if (columnDiff == null) continue;
            cfDiff.addColumn(columnDiff);
        }
        if (!cfDiff.isEmpty()) {
            return cfDiff;
        }
        return null;
    }

    public long dataSize() {
        long size = 0L;
        for (Column column : this) {
            size += (long)column.dataSize();
        }
        return size;
    }

    public long maxTimestamp() {
        long maxTimestamp = this.deletionInfo().maxTimestamp();
        for (Column column : this) {
            maxTimestamp = Math.max(maxTimestamp, column.maxTimestamp());
        }
        return maxTimestamp;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(373, 75437).append((Object)this.metadata).append((Object)this.deletionInfo());
        for (Column column : this) {
            builder.append((Object)column);
        }
        return builder.toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ColumnFamily)) {
            return false;
        }
        ColumnFamily comparison = (ColumnFamily)o;
        return this.metadata.equals(comparison.metadata) && this.deletionInfo().equals(comparison.deletionInfo()) && ByteBufferUtil.compareUnsigned(ColumnFamily.digest(this), ColumnFamily.digest(comparison)) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamily(");
        sb.append(this.metadata == null ? "<anonymous>" : this.metadata.cfName);
        if (this.isMarkedForDelete()) {
            sb.append(" -").append(this.deletionInfo()).append("-");
        }
        sb.append(" [").append(this.getComparator().getColumnsString(this)).append("])");
        return sb.toString();
    }

    public static ByteBuffer digest(ColumnFamily cf) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        if (cf != null) {
            cf.updateDigest(digest);
        }
        return ByteBuffer.wrap(digest.digest());
    }

    public void updateDigest(MessageDigest digest) {
        for (Column column : this) {
            column.updateDigest(digest);
        }
    }

    public static ColumnFamily diff(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        return cf1.diff(cf2);
    }

    public void resolve(ColumnFamily cf) {
        this.resolve(cf, HeapAllocator.instance);
    }

    public void resolve(ColumnFamily cf, Allocator allocator) {
        if (cf == null) {
            return;
        }
        this.addAll(cf, allocator);
    }

    public ColumnStats getColumnStats() {
        ColumnStats.MinTracker<Long> minTimestampTracker = new ColumnStats.MinTracker<Long>(Long.MIN_VALUE);
        ColumnStats.MaxTracker<Long> maxTimestampTracker = new ColumnStats.MaxTracker<Long>(Long.MAX_VALUE);
        StreamingHistogram tombstones = new StreamingHistogram(100);
        ColumnStats.MaxTracker<Integer> maxDeletionTimeTracker = new ColumnStats.MaxTracker<Integer>(Integer.MAX_VALUE);
        List<ByteBuffer> minColumnNamesSeen = Collections.emptyList();
        List<ByteBuffer> maxColumnNamesSeen = Collections.emptyList();
        if (this.deletionInfo().getTopLevelDeletion().localDeletionTime < Integer.MAX_VALUE) {
            tombstones.update(this.deletionInfo().getTopLevelDeletion().localDeletionTime);
            maxDeletionTimeTracker.update(this.deletionInfo().getTopLevelDeletion().localDeletionTime);
            minTimestampTracker.update(this.deletionInfo().getTopLevelDeletion().markedForDeleteAt);
            maxTimestampTracker.update(this.deletionInfo().getTopLevelDeletion().markedForDeleteAt);
        }
        Iterator<RangeTombstone> it = this.deletionInfo().rangeIterator();
        while (it.hasNext()) {
            RangeTombstone rangeTombstone = it.next();
            tombstones.update(rangeTombstone.getLocalDeletionTime());
            minTimestampTracker.update(rangeTombstone.minTimestamp());
            maxTimestampTracker.update(rangeTombstone.maxTimestamp());
            maxDeletionTimeTracker.update(rangeTombstone.getLocalDeletionTime());
            minColumnNamesSeen = ColumnNameHelper.minComponents(minColumnNamesSeen, (ByteBuffer)rangeTombstone.min, this.metadata.comparator);
            maxColumnNamesSeen = ColumnNameHelper.maxComponents(maxColumnNamesSeen, (ByteBuffer)rangeTombstone.max, this.metadata.comparator);
        }
        for (Column column : this) {
            minTimestampTracker.update(column.minTimestamp());
            maxTimestampTracker.update(column.maxTimestamp());
            maxDeletionTimeTracker.update(column.getLocalDeletionTime());
            int deletionTime = column.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                tombstones.update(deletionTime);
            }
            minColumnNamesSeen = ColumnNameHelper.minComponents(minColumnNamesSeen, column.name, this.metadata.comparator);
            maxColumnNamesSeen = ColumnNameHelper.maxComponents(maxColumnNamesSeen, column.name, this.metadata.comparator);
        }
        return new ColumnStats(this.getColumnCount(), minTimestampTracker.get(), maxTimestampTracker.get(), maxDeletionTimeTracker.get(), tombstones, minColumnNamesSeen, maxColumnNamesSeen);
    }

    public boolean isMarkedForDelete() {
        return !this.deletionInfo().isLive();
    }

    public AbstractType<?> getComparator() {
        return this.metadata.comparator;
    }

    public boolean hasOnlyTombstones(long now) {
        for (Column column : this) {
            if (!column.isLive(now)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Column> iterator() {
        return this.getSortedColumns().iterator();
    }

    public Iterator<Column> reverseIterator() {
        return this.getReverseSortedColumns().iterator();
    }

    public boolean hasIrrelevantData(int gcBefore) {
        if (this.deletionInfo().hasPurgeableTombstones(gcBefore)) {
            return true;
        }
        DeletionInfo.InOrderTester tester = this.inOrderDeletionTester();
        for (Column column : this) {
            if (!tester.isDeleted(column) && !column.hasIrrelevantData(gcBefore)) continue;
            return true;
        }
        return false;
    }

    public Map<ByteBuffer, ByteBuffer> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column column : this) {
            builder.put((Object)column.name, (Object)column.value);
        }
        return builder.build();
    }

    public static ColumnFamily fromBytes(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize(new DataInputStream(ByteBufferUtil.inputStream(bytes)), UnsortedColumns.factory, ColumnSerializer.Flag.LOCAL, 7);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer toBytes() {
        DataOutputBuffer out = new DataOutputBuffer();
        serializer.serialize(this, (DataOutput)out, 7);
        return ByteBuffer.wrap(out.getData(), 0, out.getLength());
    }

    public BatchRemoveIterator<Column> batchRemoveIterator() {
        return new BatchRemoveIterator<Column>(){
            private final Iterator<Column> iter;
            {
                this.iter = ColumnFamily.this.iterator();
            }

            @Override
            public void commit() {
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Column next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public static abstract class Factory<T extends ColumnFamily> {
        public abstract T create(CFMetaData var1, boolean var2);

        public T create(CFMetaData metadata) {
            return this.create(metadata, false);
        }

        public T create(String keyspace, String cfName) {
            return this.create(Schema.instance.getCFMetaData(keyspace, cfName));
        }
    }
}

