/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Selectable;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Selection {
    private final List<CFDefinition.Name> columns;
    private final List<ColumnSpecification> metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(List<CFDefinition.Name> columns, List<ColumnSpecification> metadata, boolean collectTimestamps, boolean collectTTLs) {
        this.columns = columns;
        this.metadata = metadata;
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public boolean isWildcard() {
        return false;
    }

    public ResultSet.Metadata getResultMetadata() {
        return new ResultSet.Metadata(this.metadata);
    }

    public static Selection wildcard(CFDefinition cfDef) {
        ArrayList<CFDefinition.Name> all = new ArrayList<CFDefinition.Name>();
        for (CFDefinition.Name name : cfDef) {
            all.add(name);
        }
        return new SimpleSelection(all, true);
    }

    public static Selection forColumns(List<CFDefinition.Name> columns) {
        return new SimpleSelection(columns, false);
    }

    private static boolean selectionsNeedProcessing(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (!rawSelector.processesSelection()) continue;
            return true;
        }
        return false;
    }

    private static int addAndGetIndex(CFDefinition.Name name, List<CFDefinition.Name> l) {
        int idx = l.indexOf(name);
        if (idx < 0) {
            idx = l.size();
            l.add(name);
        }
        return idx;
    }

    private static Selector makeSelector(CFDefinition cfDef, RawSelector raw, List<CFDefinition.Name> names, List<ColumnSpecification> metadata) throws InvalidRequestException {
        Selectable selectable = raw.selectable.prepare(cfDef.cfm);
        return Selection.makeSelector(cfDef, selectable, raw.alias, names, metadata);
    }

    private static Selector makeSelector(CFDefinition cfDef, Selectable selectable, ColumnIdentifier alias, List<CFDefinition.Name> names, List<ColumnSpecification> metadata) throws InvalidRequestException {
        if (selectable instanceof ColumnIdentifier) {
            CFDefinition.Name name = cfDef.get((ColumnIdentifier)selectable);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", selectable));
            }
            if (metadata != null) {
                metadata.add(alias == null ? name : Selection.makeAliasSpec(cfDef, name.type, alias));
            }
            return new SimpleSelector(name.toString(), Selection.addAndGetIndex(name, names), name.type);
        }
        if (selectable instanceof Selectable.WritetimeOrTTL) {
            Selectable.WritetimeOrTTL tot = (Selectable.WritetimeOrTTL)selectable;
            CFDefinition.Name name = cfDef.get(tot.id);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", tot.id));
            }
            if (name.isPrimaryKeyColumn()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", tot.isWritetime ? "writeTime" : "ttl", name));
            }
            if (name.type.isCollection()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on collections", tot.isWritetime ? "writeTime" : "ttl"));
            }
            if (metadata != null) {
                metadata.add(Selection.makeWritetimeOrTTLSpec(cfDef, tot, alias));
            }
            return new WritetimeOrTTLSelector(name.toString(), Selection.addAndGetIndex(name, names), tot.isWritetime);
        }
        Selectable.WithFunction withFun = (Selectable.WithFunction)selectable;
        ArrayList<Selector> args = new ArrayList<Selector>(withFun.args.size());
        for (Selectable rawArg : withFun.args) {
            args.add(Selection.makeSelector(cfDef, rawArg, null, names, null));
        }
        AbstractType<?> returnType = Functions.getReturnType(withFun.functionName, cfDef.cfm.ksName, cfDef.cfm.cfName);
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function '%s'", withFun.functionName));
        }
        ColumnSpecification spec = Selection.makeFunctionSpec(cfDef, withFun, returnType, alias);
        Function fun = Functions.get(withFun.functionName, args, spec);
        if (metadata != null) {
            metadata.add(spec);
        }
        return new FunctionSelector(fun, args);
    }

    private static ColumnSpecification makeWritetimeOrTTLSpec(CFDefinition cfDef, Selectable.WritetimeOrTTL tot, ColumnIdentifier alias) {
        return new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, alias == null ? new ColumnIdentifier(tot.toString(), true) : alias, tot.isWritetime ? LongType.instance : Int32Type.instance);
    }

    private static ColumnSpecification makeFunctionSpec(CFDefinition cfDef, Selectable.WithFunction fun, AbstractType<?> returnType, ColumnIdentifier alias) throws InvalidRequestException {
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", fun.functionName));
        }
        return new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, alias == null ? new ColumnIdentifier(fun.toString(), true) : alias, returnType);
    }

    private static ColumnSpecification makeAliasSpec(CFDefinition cfDef, AbstractType<?> type, ColumnIdentifier alias) {
        return new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, alias, type);
    }

    public static Selection fromSelectors(CFDefinition cfDef, List<RawSelector> rawSelectors) throws InvalidRequestException {
        boolean needsProcessing = Selection.selectionsNeedProcessing(rawSelectors);
        if (needsProcessing) {
            ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>();
            ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
            ArrayList<Selector> selectors = new ArrayList<Selector>(rawSelectors.size());
            boolean collectTimestamps = false;
            boolean collectTTLs = false;
            for (RawSelector rawSelector : rawSelectors) {
                Selector selector = Selection.makeSelector(cfDef, rawSelector, names, metadata);
                selectors.add(selector);
                collectTimestamps |= selector.usesTimestamps();
                collectTTLs |= selector.usesTTLs();
            }
            return new SelectionWithProcessing(names, metadata, selectors, collectTimestamps, collectTTLs);
        }
        ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>(rawSelectors.size());
        ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
        for (RawSelector rawSelector : rawSelectors) {
            assert (rawSelector.selectable instanceof ColumnIdentifier.Raw);
            ColumnIdentifier id = ((ColumnIdentifier.Raw)rawSelector.selectable).prepare(cfDef.cfm);
            CFDefinition.Name name = cfDef.get(id);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", id));
            }
            names.add(name);
            metadata.add(rawSelector.alias == null ? name : Selection.makeAliasSpec(cfDef, name.type, rawSelector.alias));
        }
        return new SimpleSelection(names, metadata, false);
    }

    protected abstract List<ByteBuffer> handleRow(ResultSetBuilder var1) throws InvalidRequestException;

    public List<ColumnIdentifier> regularAndStaticColumnsToFetch() {
        ArrayList<ColumnIdentifier> toFetch = new ArrayList<ColumnIdentifier>();
        for (CFDefinition.Name name : this.columns) {
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.STATIC) continue;
            toFetch.add(name.name);
        }
        return toFetch;
    }

    public List<CFDefinition.Name> getColumns() {
        return this.columns;
    }

    public ResultSetBuilder resultSetBuilder(long now) {
        return new ResultSetBuilder(now);
    }

    private static ByteBuffer value(Column c) {
        return c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private static class WritetimeOrTTLSelector
    implements Selector {
        private final String columnName;
        private final int idx;
        private final boolean isWritetime;

        public WritetimeOrTTLSelector(String columnName, int idx, boolean isWritetime) {
            this.columnName = columnName;
            this.idx = idx;
            this.isWritetime = isWritetime;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            if (this.isWritetime) {
                long ts = rs.timestamps[this.idx];
                return ts != Long.MIN_VALUE ? ByteBufferUtil.bytes(ts) : null;
            }
            int ttl = rs.ttls[this.idx];
            return ttl > 0 ? ByteBufferUtil.bytes(ttl) : null;
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return receiver.type.isValueCompatibleWith(this.isWritetime ? LongType.instance : Int32Type.instance);
        }

        @Override
        public boolean usesTimestamps() {
            return this.isWritetime;
        }

        @Override
        public boolean usesTTLs() {
            return !this.isWritetime;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private static class FunctionSelector
    implements Selector {
        private final Function fun;
        private final List<Selector> argSelectors;

        public FunctionSelector(Function fun, List<Selector> argSelectors) {
            this.fun = fun;
            this.argSelectors = argSelectors;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>(this.argSelectors.size());
            for (Selector s : this.argSelectors) {
                args.add(s.compute(rs));
            }
            return this.fun.execute(args);
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return receiver.type.isValueCompatibleWith(this.fun.returnType());
        }

        @Override
        public boolean usesTimestamps() {
            for (Selector s : this.argSelectors) {
                if (!s.usesTimestamps()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean usesTTLs() {
            for (Selector s : this.argSelectors) {
                if (!s.usesTTLs()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fun.name()).append("(");
            for (int i = 0; i < this.argSelectors.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.argSelectors.get(i));
            }
            return sb.append(")").toString();
        }
    }

    private static class SimpleSelector
    implements Selector {
        private final String columnName;
        private final int idx;
        private final AbstractType<?> type;

        public SimpleSelector(String columnName, int idx, AbstractType<?> type) {
            this.columnName = columnName;
            this.idx = idx;
            this.type = type;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            return rs.current.get(this.idx);
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return receiver.type.isValueCompatibleWith(this.type);
        }

        @Override
        public boolean usesTimestamps() {
            return false;
        }

        @Override
        public boolean usesTTLs() {
            return false;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private static interface Selector
    extends AssignementTestable {
        public ByteBuffer compute(ResultSetBuilder var1) throws InvalidRequestException;

        public boolean usesTimestamps();

        public boolean usesTTLs();
    }

    private static class SelectionWithProcessing
    extends Selection {
        private final List<Selector> selectors;

        public SelectionWithProcessing(List<CFDefinition.Name> columns, List<ColumnSpecification> metadata, List<Selector> selectors, boolean collectTimestamps, boolean collectTTLs) {
            super(columns, metadata, collectTimestamps, collectTTLs);
            this.selectors = selectors;
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
            for (Selector selector : this.selectors) {
                result.add(selector.compute(rs));
            }
            return result;
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(List<CFDefinition.Name> columns, boolean isWildcard) {
            this(columns, new ArrayList<ColumnSpecification>(columns), isWildcard);
        }

        public SimpleSelection(List<CFDefinition.Name> columns, List<ColumnSpecification> metadata, boolean isWildcard) {
            super(columns, metadata, false, false);
            this.isWildcard = isWildcard;
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) {
            return rs.current;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;
        final long now;

        private ResultSetBuilder(long now) {
            this.resultSet = new ResultSet(Selection.this.metadata);
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columns.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columns.size()] : null;
            this.now = now;
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(Column c) {
            this.current.add(this.isDead(c) ? null : Selection.value(c));
            if (this.timestamps != null) {
                long l = this.timestamps[this.current.size() - 1] = this.isDead(c) ? Long.MIN_VALUE : c.timestamp();
            }
            if (this.ttls != null) {
                int ttl = -1;
                if (!this.isDead(c) && c instanceof ExpiringColumn) {
                    ttl = c.getLocalDeletionTime() - (int)(this.now / 1000L);
                }
                this.ttls[this.current.size() - 1] = ttl;
            }
        }

        private boolean isDead(Column c) {
            return c == null || c.isMarkedForDelete(this.now);
        }

        public void newRow() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columns.size());
        }

        public ResultSet build() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
                this.current = null;
            }
            return this.resultSet;
        }
    }
}

