/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCondition {
    public final CFDefinition.Name column;
    private final Term collectionElement;
    private final Term value;

    private ColumnCondition(CFDefinition.Name column, Term collectionElement, Term value) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
    }

    public static ColumnCondition equal(CFDefinition.Name column, Term value) {
        return new ColumnCondition(column, null, value);
    }

    public static ColumnCondition equal(CFDefinition.Name column, Term collectionElement, Term value) {
        return new ColumnCondition(column, collectionElement, value);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        this.value.collectMarkerSpecification(boundNames);
    }

    public Bound bind(List<ByteBuffer> variables) throws InvalidRequestException {
        return this.column.type instanceof CollectionType ? (this.collectionElement == null ? new CollectionBound(this, variables) : new ElementAccessBound(this, variables)) : new SimpleBound(this, variables);
    }

    public static class Raw {
        private final Term.Raw value;
        private final Term.Raw collectionElement;

        private Raw(Term.Raw value, Term.Raw collectionElement) {
            this.value = value;
            this.collectionElement = collectionElement;
        }

        public static Raw simpleEqual(Term.Raw value) {
            return new Raw(value, null);
        }

        public static Raw collectionEqual(Term.Raw value, Term.Raw collectionElement) {
            return new Raw(value, collectionElement);
        }

        public ColumnCondition prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Condtions on counters are not supported");
            }
            if (this.collectionElement == null) {
                return ColumnCondition.equal(receiver, this.value.prepare(receiver));
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(Lists.indexSpecOf(receiver)), this.value.prepare(Lists.valueSpecOf(receiver)));
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                case MAP: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(Maps.keySpecOf(receiver)), this.value.prepare(Maps.valueSpecOf(receiver)));
                }
            }
            throw new AssertionError();
        }
    }

    private static class CollectionBound
    extends Bound {
        public final Term.Terminal value;

        private CollectionBound(ColumnCondition condition, List<ByteBuffer> variables) throws InvalidRequestException {
            super(condition.column);
            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
            this.value = condition.value.bind(variables);
        }

        @Override
        public boolean appliesTo(ColumnNameBuilder rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            CFMetaData cfm = current.metadata();
            ColumnNameBuilder collectionPrefix = this.copyOrUpdatePrefix(cfm, rowPrefix).add(this.column.name.key);
            Iterator<Column> iter = this.collectionColumns(collectionPrefix, current, now);
            if (this.value == null) {
                return !iter.hasNext();
            }
            switch (type.kind) {
                case LIST: {
                    return this.listAppliesTo((ListType)type, cfm, iter, ((Lists.Value)this.value).elements);
                }
                case SET: {
                    return this.setAppliesTo((SetType)type, cfm, iter, ((Sets.Value)this.value).elements);
                }
                case MAP: {
                    return this.mapAppliesTo((MapType)type, cfm, iter, ((Maps.Value)this.value).map);
                }
            }
            throw new AssertionError();
        }

        private ByteBuffer collectionKey(CFMetaData cfm, Column c) {
            ByteBuffer[] bbs = ((CompositeType)cfm.comparator).split(c.name());
            return bbs[bbs.length - 1];
        }

        private boolean listAppliesTo(ListType type, CFMetaData cfm, Iterator<Column> iter, List<ByteBuffer> elements) {
            for (ByteBuffer e : elements) {
                if (iter.hasNext() && type.elements.compare(iter.next().value(), e) == 0) continue;
                return false;
            }
            return !iter.hasNext();
        }

        private boolean setAppliesTo(SetType type, CFMetaData cfm, Iterator<Column> iter, Set<ByteBuffer> elements) {
            TreeSet<ByteBuffer> remaining = new TreeSet<ByteBuffer>(type.elements);
            remaining.addAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                if (remaining.remove(this.collectionKey(cfm, iter.next()))) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapAppliesTo(MapType type, CFMetaData cfm, Iterator<Column> iter, Map<ByteBuffer, ByteBuffer> elements) {
            TreeMap<ByteBuffer, ByteBuffer> remaining = new TreeMap<ByteBuffer, ByteBuffer>(type.keys);
            remaining.putAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                Column c = iter.next();
                ByteBuffer previous = (ByteBuffer)remaining.remove(this.collectionKey(cfm, c));
                if (previous != null && type.values.compare(previous, c.value()) == 0) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollectionBound)) {
                return false;
            }
            CollectionBound that = (CollectionBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            ByteBuffer thisVal = this.value.get();
            ByteBuffer thatVal = that.value.get();
            return thisVal == null || thatVal == null ? thisVal == null && thatVal == null : this.column.type.compare(thisVal, thatVal) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.value.get()});
        }
    }

    private static class ElementAccessBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final ByteBuffer value;

        private ElementAccessBound(ColumnCondition condition, List<ByteBuffer> variables) throws InvalidRequestException {
            super(condition.column);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            this.collectionElement = condition.collectionElement.bindAndGet(variables);
            this.value = condition.value.bindAndGet(variables);
        }

        @Override
        public boolean appliesTo(ColumnNameBuilder rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            ColumnNameBuilder collectionPrefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix).add(this.column.name.key);
            if (this.column.type instanceof MapType) {
                return this.equalsValue(this.value, current.getColumn(collectionPrefix.add(this.collectionElement).build()), ((MapType)this.column.type).values, now);
            }
            assert (this.column.type instanceof ListType);
            int idx = ByteBufferUtil.toInt(this.collectionElement);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            Iterator<Column> iter = this.collectionColumns(collectionPrefix, current, now);
            int adv = Iterators.advance(iter, (int)idx);
            if (adv != idx || !iter.hasNext()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, adv));
            }
            if (this.value == null) {
                return false;
            }
            return ((ListType)this.column.type).elements.compare(iter.next().value(), this.value) == 0;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ElementAccessBound)) {
                return false;
            }
            ElementAccessBound that = (ElementAccessBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            if (this.collectionElement == null != (that.collectionElement == null)) {
                return false;
            }
            if (this.collectionElement != null) {
                Int32Type comparator;
                assert (this.column.type instanceof ListType || this.column.type instanceof MapType);
                AbstractType abstractType = comparator = this.column.type instanceof ListType ? Int32Type.instance : ((MapType)this.column.type).keys;
                if (comparator.compare(this.collectionElement, that.collectionElement) != 0) {
                    return false;
                }
            }
            return this.column.type.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.collectionElement, this.value});
        }
    }

    private static class SimpleBound
    extends Bound {
        public final ByteBuffer value;

        private SimpleBound(ColumnCondition condition, List<ByteBuffer> variables) throws InvalidRequestException {
            super(condition.column);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            this.value = condition.value.bindAndGet(variables);
        }

        @Override
        public boolean appliesTo(ColumnNameBuilder rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            ColumnNameBuilder prefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix);
            ByteBuffer columnName = this.column.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? prefix.build() : prefix.add(this.column.name.key).build();
            return this.equalsValue(this.value, current.getColumn(columnName), this.column.type, now);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleBound)) {
                return false;
            }
            SimpleBound that = (SimpleBound)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return this.value == null || that.value == null ? this.value == null && that.value == null : this.column.type.compare(this.value, that.value) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.value});
        }
    }

    public static abstract class Bound {
        public final CFDefinition.Name column;

        protected Bound(CFDefinition.Name column) {
            this.column = column;
        }

        public abstract boolean appliesTo(ColumnNameBuilder var1, ColumnFamily var2, long var3) throws InvalidRequestException;

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected ColumnNameBuilder copyOrUpdatePrefix(CFMetaData cfm, ColumnNameBuilder rowPrefix) {
            return this.column.kind == CFDefinition.Name.Kind.STATIC ? cfm.getStaticColumnNameBuilder() : rowPrefix.copy();
        }

        protected boolean equalsValue(ByteBuffer value, Column c, AbstractType<?> type, long now) {
            return value == null ? c == null || !c.isLive(now) : c != null && c.isLive(now) && type.compare(c.value(), value) == 0;
        }

        protected Iterator<Column> collectionColumns(ColumnNameBuilder collectionPrefix, ColumnFamily cf, final long now) {
            ColumnSlice[] collectionSlice = new ColumnSlice[]{new ColumnSlice(collectionPrefix.build(), collectionPrefix.buildAsEndOfRange())};
            return Iterators.filter(cf.iterator(collectionSlice), (Predicate)new Predicate<Column>(){

                public boolean apply(Column c) {
                    return c.isLive(now);
                }
            });
        }
    }
}

