/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsCache {
    private static final Logger logger = LoggerFactory.getLogger(PermissionsCache.class);
    private final ThreadPoolExecutor cacheRefreshExecutor = new DebuggableThreadPoolExecutor("PermissionsCacheRefresh", 5);
    private final IAuthorizer authorizer;
    private final LoadingCache<Pair<AuthenticatedUser, IResource>, Set<Permission>> cache;

    public PermissionsCache(int validityPeriod, int updateInterval, int maxEntries, IAuthorizer authorizer) {
        this.authorizer = authorizer;
        this.cache = this.initCache(validityPeriod, updateInterval, maxEntries);
    }

    public Set<Permission> getPermissions(AuthenticatedUser user, IResource resource) {
        if (this.cache == null) {
            return this.authorizer.authorize(user, resource);
        }
        try {
            return (Set)this.cache.get(Pair.create(user, resource));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private LoadingCache<Pair<AuthenticatedUser, IResource>, Set<Permission>> initCache(int validityPeriod, int updateInterval, int maxEntries) {
        if (this.authorizer instanceof AllowAllAuthorizer) {
            return null;
        }
        if (validityPeriod <= 0) {
            return null;
        }
        return CacheBuilder.newBuilder().refreshAfterWrite((long)updateInterval, TimeUnit.MILLISECONDS).expireAfterWrite((long)validityPeriod, TimeUnit.MILLISECONDS).maximumSize((long)maxEntries).build((CacheLoader)new CacheLoader<Pair<AuthenticatedUser, IResource>, Set<Permission>>(){

            public Set<Permission> load(Pair<AuthenticatedUser, IResource> userResource) {
                return PermissionsCache.this.authorizer.authorize((AuthenticatedUser)userResource.left, (IResource)userResource.right);
            }

            public ListenableFuture<Set<Permission>> reload(final Pair<AuthenticatedUser, IResource> userResource, Set<Permission> oldValue) {
                ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Set<Permission>>(){

                    @Override
                    public Set<Permission> call() throws Exception {
                        try {
                            return PermissionsCache.this.authorizer.authorize((AuthenticatedUser)userResource.left, (IResource)userResource.right);
                        }
                        catch (Exception e) {
                            logger.debug("Error performing async refresh of user permissions", (Throwable)e);
                            throw e;
                        }
                    }
                });
                PermissionsCache.this.cacheRefreshExecutor.execute((Runnable)task);
                return task;
            }
        });
    }
}

