/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.IVersionedSerializer;

class EndpointStateSerializer
implements IVersionedSerializer<EndpointState> {
    EndpointStateSerializer() {
    }

    @Override
    public void serialize(EndpointState epState, DataOutput dos, int version) throws IOException {
        HeartBeatState hbState = epState.getHeartBeatState();
        HeartBeatState.serializer.serialize(hbState, dos, version);
        int size = epState.applicationState.size();
        dos.writeInt(size);
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.applicationState.entrySet()) {
            VersionedValue value = entry.getValue();
            dos.writeInt(entry.getKey().ordinal());
            VersionedValue.serializer.serialize(value, dos, version);
        }
    }

    @Override
    public EndpointState deserialize(DataInput dis, int version) throws IOException {
        HeartBeatState hbState = HeartBeatState.serializer.deserialize(dis, version);
        EndpointState epState = new EndpointState(hbState);
        int appStateSize = dis.readInt();
        for (int i = 0; i < appStateSize; ++i) {
            int key = dis.readInt();
            VersionedValue value = VersionedValue.serializer.deserialize(dis, version);
            epState.addApplicationState(Gossiper.STATES[key], value);
        }
        return epState;
    }

    @Override
    public long serializedSize(EndpointState epState, int version) {
        long size = HeartBeatState.serializer.serializedSize(epState.getHeartBeatState(), version);
        size += (long)TypeSizes.NATIVE.sizeof(epState.applicationState.size());
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.applicationState.entrySet()) {
            VersionedValue value = entry.getValue();
            size += (long)TypeSizes.NATIVE.sizeof(entry.getKey().ordinal());
            size += VersionedValue.serializer.serializedSize(value, version);
        }
        return size;
    }
}

