/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet.springboot;

import javax.servlet.Servlet;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.component.servlet.springboot.ServletMappingConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"camel.component.servlet.mapping.enabled"}, matchIfMissing=true)
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ServletMappingConfiguration.class})
public class ServletMappingAutoConfiguration {
    @Bean
    ServletRegistrationBean servletRegistrationBean(ServletMappingConfiguration config) {
        ServletRegistrationBean mapping = new ServletRegistrationBean();
        mapping.setServlet((Servlet)new CamelHttpTransportServlet());
        mapping.addUrlMappings(new String[]{config.getContextPath()});
        mapping.setName(config.getServletName());
        mapping.setLoadOnStartup(1);
        return mapping;
    }
}

