/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.language.joor.JoorLanguage;
import org.apache.camel.language.joor.springboot.JoorLanguageConfiguration;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.LanguageConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={LanguageConfigurationProperties.class, JoorLanguageConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.language", "camel.language.joor"})
public class JoorLanguageAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private JoorLanguageConfiguration configuration;

    public JoorLanguageAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public LanguageCustomizer configureJoorLanguage() {
        return new LanguageCustomizer(){

            public void configure(String name, Language target) {
                CamelPropertiesHelper.copyProperties((CamelContext)JoorLanguageAutoConfiguration.this.camelContext, (Object)((Object)JoorLanguageAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Language target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)JoorLanguageAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.language.customizer", "camel.language.joor.customizer"}) && target instanceof JoorLanguage;
            }
        };
    }
}

