/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventHelper.class);

    private EventHelper() {
    }

    public static boolean notifyCamelContextStarting(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStartingEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextStarted(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStartedEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextStartupFailed(CamelContext context, Throwable cause) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStartupFailureEvent(context, cause), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextStopping(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStoppingEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextStopped(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStoppedEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextStopFailure(CamelContext context, Throwable cause) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextStopFailureEvent(context, cause), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyServiceStopFailure(CamelContext context, Object service, Throwable cause) {
        return EventHelper.doNotify(context, factory -> factory.createServiceStopFailureEvent(context, service, cause), EventNotifier::isIgnoreServiceEvents);
    }

    public static boolean notifyServiceStartupFailure(CamelContext context, Object service, Throwable cause) {
        return EventHelper.doNotify(context, factory -> factory.createServiceStartupFailureEvent(context, service, cause), EventNotifier::isIgnoreServiceEvents);
    }

    public static boolean notifyRouteStarted(CamelContext context, Route route) {
        return EventHelper.doNotify(context, factory -> factory.createRouteStartedEvent(route), EventNotifier::isIgnoreRouteEvents);
    }

    public static boolean notifyRouteStopped(CamelContext context, Route route) {
        return EventHelper.doNotify(context, factory -> factory.createRouteStoppedEvent(route), EventNotifier::isIgnoreRouteEvents);
    }

    public static boolean notifyRouteAdded(CamelContext context, Route route) {
        return EventHelper.doNotify(context, factory -> factory.createRouteAddedEvent(route), EventNotifier::isIgnoreRouteEvents);
    }

    public static boolean notifyRouteRemoved(CamelContext context, Route route) {
        return EventHelper.doNotify(context, factory -> factory.createRouteRemovedEvent(route), EventNotifier::isIgnoreRouteEvents);
    }

    public static boolean notifyExchangeCreated(CamelContext context, Exchange exchange) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeCreatedEvent(exchange), EventNotifier::isIgnoreExchangeCreatedEvent);
    }

    public static boolean notifyExchangeDone(CamelContext context, Exchange exchange) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeCompletedEvent(exchange), EventNotifier::isIgnoreExchangeCompletedEvent);
    }

    public static boolean notifyExchangeFailed(CamelContext context, Exchange exchange) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeFailedEvent(exchange), EventNotifier::isIgnoreExchangeFailedEvents);
    }

    public static boolean notifyExchangeFailureHandling(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeFailureHandlingEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri), EventNotifier::isIgnoreExchangeFailedEvents);
    }

    public static boolean notifyExchangeFailureHandled(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeFailureHandledEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri), EventNotifier::isIgnoreExchangeFailedEvents);
    }

    public static boolean notifyExchangeRedelivery(CamelContext context, Exchange exchange, int attempt) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeRedeliveryEvent(exchange, attempt), EventNotifier::isIgnoreExchangeRedeliveryEvents);
    }

    public static boolean notifyExchangeSending(CamelContext context, Exchange exchange, Endpoint endpoint) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeSendingEvent(exchange, endpoint), EventNotifier::isIgnoreExchangeSendingEvents);
    }

    public static boolean notifyExchangeSent(CamelContext context, Exchange exchange, Endpoint endpoint, long timeTaken) {
        return EventHelper.doNotifyExchange(context, exchange, factory -> factory.createExchangeSentEvent(exchange, endpoint, timeTaken), EventNotifier::isIgnoreExchangeSentEvents);
    }

    public static boolean notifyStepStarted(CamelContext context, Exchange exchange, String stepId) {
        return EventHelper.doNotifyStep(context, exchange, factory -> factory.createStepStartedEvent(exchange, stepId), EventNotifier::isIgnoreStepEvents);
    }

    public static boolean notifyStepDone(CamelContext context, Exchange exchange, String stepId) {
        return EventHelper.doNotifyStep(context, exchange, factory -> factory.createStepCompletedEvent(exchange, stepId), EventNotifier::isIgnoreStepEvents);
    }

    public static boolean notifyStepFailed(CamelContext context, Exchange exchange, String stepId) {
        return EventHelper.doNotifyStep(context, exchange, factory -> factory.createStepFailedEvent(exchange, stepId), EventNotifier::isIgnoreStepEvents);
    }

    public static boolean notifyCamelContextSuspending(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextSuspendingEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextSuspended(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextSuspendedEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextResuming(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextResumingEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextResumed(CamelContext context) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextResumedEvent(context), EventNotifier::isIgnoreCamelContextEvents);
    }

    public static boolean notifyCamelContextResumeFailed(CamelContext context, Throwable cause) {
        return EventHelper.doNotify(context, factory -> factory.createCamelContextResumeFailureEvent(context, cause), EventNotifier::isIgnoreCamelContextEvents);
    }

    private static boolean doNotifyExchange(CamelContext context, Exchange exchange, Function<EventFactory, CamelEvent> eventSupplier, Predicate<EventNotifier> notifierFilter) {
        if (((Boolean)exchange.getProperty("CamelNotifyEvent", (Object)false, Boolean.class)).booleanValue()) {
            return false;
        }
        return EventHelper.doNotify(context, eventSupplier, notifierFilter.or(EventNotifier::isIgnoreExchangeEvents));
    }

    private static boolean doNotifyStep(CamelContext context, Exchange exchange, Function<EventFactory, CamelEvent> eventSupplier, Predicate<EventNotifier> notifierFilter) {
        if (((Boolean)exchange.getProperty("CamelNotifyEvent", (Object)false, Boolean.class)).booleanValue()) {
            return false;
        }
        return EventHelper.doNotify(context, eventSupplier, notifierFilter.or(EventNotifier::isIgnoreStepEvents));
    }

    private static boolean doNotify(CamelContext context, Function<EventFactory, CamelEvent> eventSupplier, Predicate<EventNotifier> notifierFilter) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifierFilter.test(notifier)) continue;
            if (event == null && (event = eventSupplier.apply(factory)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    private static boolean doNotifyEvent(EventNotifier notifier, CamelEvent event) {
        if (!ServiceHelper.isStarted((Object)notifier)) {
            LOG.debug("Ignoring notifying event {}. The EventNotifier has not been started yet: {}", (Object)event, (Object)notifier);
            return false;
        }
        if (!notifier.isEnabled(event)) {
            LOG.trace("Notifier: {} is not enabled for the event: {}", (Object)notifier, (Object)event);
            return false;
        }
        try {
            notifier.notify(event);
        }
        catch (Throwable e) {
            LOG.warn("Error notifying event " + event + ". This exception will be ignored. ", e);
        }
        return true;
    }
}

