/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.client.RestClient;

public class SyncResponseCallback
implements RestClient.ResponseCallback {
    private InputStream response;
    private SalesforceException exception;
    private Map<String, String> headers;
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onResponse(InputStream response, Map<String, String> headers, SalesforceException exception) {
        this.response = response;
        this.headers = headers;
        this.exception = exception;
        this.latch.countDown();
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
    }

    public boolean await(long duration, TimeUnit unit) throws InterruptedException {
        return this.latch.await(duration, unit);
    }

    public InputStream getResponse() {
        return this.response;
    }

    public SalesforceException getException() {
        return this.exception;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

