/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.SalesforceMultipleChoicesException;
import org.apache.camel.component.salesforce.api.TypeReferences;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;

public class DefaultRestClient
extends AbstractClientBase
implements RestClient {
    private static final String SERVICES_DATA = "/services/data/";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String SERVICES_APEXREST = "/services/apexrest/";
    private ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public DefaultRestClient(SalesforceHttpClient httpClient, String version, SalesforceSession session, SalesforceLoginConfig loginConfig) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
    }

    @Override
    protected void doHttpRequest(Request request, AbstractClientBase.ClientResponseCallback callback) {
        request.header(HttpHeader.ACCEPT, "application/json;charset=utf-8");
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        super.doHttpRequest(request, callback);
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        int statusCode = response.getStatus();
        String reason = response.getReason();
        if (reason == null || reason.isEmpty()) {
            reason = HttpStatus.getMessage((int)statusCode);
        }
        try {
            if (responseContent != null && responseContent.available() > 0) {
                if (statusCode == 300) {
                    List choices = (List)this.objectMapper.readValue(responseContent, TypeReferences.STRING_LIST_TYPE);
                    return new SalesforceMultipleChoicesException(reason, statusCode, choices);
                }
                List<RestError> restErrors = this.readErrorsFrom(responseContent, this.objectMapper);
                if (statusCode == 404) {
                    return new NoSuchSObjectException(restErrors);
                }
                return new SalesforceException(restErrors, statusCode, "Unexpected error: " + reason + ". See exception `errors` property for detail.");
            }
        }
        catch (IOException e) {
            String msg = "Unexpected Error parsing error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        catch (RuntimeException e) {
            String msg = "Unexpected Error parsing error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        return new SalesforceException("Unexpected error: " + reason + ", with content: " + responseContent, statusCode);
    }

    @Override
    public void approval(InputStream request, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request post = this.getRequest(HttpMethod.POST, this.versionUrl() + "process/approvals/", headers);
        this.setAccessToken(post);
        post.content((ContentProvider)new InputStreamContentProvider(request));
        post.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        this.doHttpRequest(post, new DelegatingClientCallback(callback));
    }

    @Override
    public void approvals(Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "process/approvals/", headers);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getVersions(Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.servicesDataUrl(), headers);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getResources(Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.versionUrl(), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getGlobalObjects(Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(""), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBasicInfo(String sObjectName, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/"), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getDescription(String sObjectName, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/describe/"), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObject(String sObjectName, String id, String[] fields, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        String params = "";
        if (fields != null && fields.length > 0) {
            StringBuilder fieldsValue = new StringBuilder("?fields=");
            for (int i = 0; i < fields.length; ++i) {
                fieldsValue.append(fields[i]);
                if (i >= fields.length - 1) continue;
                fieldsValue.append(',');
            }
            params = fieldsValue.toString();
        }
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/" + id + params), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void createSObject(String sObjectName, InputStream sObject, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request post = this.getRequest(HttpMethod.POST, this.sobjectsUrl(sObjectName), headers);
        this.setAccessToken(post);
        post.content((ContentProvider)new InputStreamContentProvider(sObject));
        post.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        this.doHttpRequest(post, new DelegatingClientCallback(callback));
    }

    @Override
    public void updateSObject(String sObjectName, String id, InputStream sObject, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request patch = this.getRequest("PATCH", this.sobjectsUrl(sObjectName + "/" + id), headers);
        this.setAccessToken(patch);
        patch.content((ContentProvider)new InputStreamContentProvider(sObject));
        patch.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObject(String sObjectName, String id, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request delete = this.getRequest(HttpMethod.DELETE, this.sobjectsUrl(sObjectName + "/" + id), headers);
        this.setAccessToken(delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getSObjectWithId(String sObjectName, String fieldName, String fieldValue, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void upsertSObject(String sObjectName, String fieldName, String fieldValue, Map<String, List<String>> headers, InputStream sObject, RestClient.ResponseCallback callback) {
        Request patch = this.getRequest("PATCH", this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue), headers);
        this.setAccessToken(patch);
        patch.content((ContentProvider)new InputStreamContentProvider(sObject));
        patch.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        this.doHttpRequest(patch, new DelegatingClientCallback(callback));
    }

    @Override
    public void deleteSObjectWithId(String sObjectName, String fieldName, String fieldValue, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request delete = this.getRequest(HttpMethod.DELETE, this.sobjectsExternalIdUrl(sObjectName, fieldName, fieldValue), headers);
        this.setAccessToken(delete);
        this.doHttpRequest(delete, new DelegatingClientCallback(callback));
    }

    @Override
    public void getBlobField(String sObjectName, String id, String blobFieldName, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.sobjectsUrl(sObjectName + "/" + id + "/" + blobFieldName), headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void query(String soqlQuery, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soqlQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "query/?q=" + encodedQuery, headers);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException(msg, e));
        }
    }

    @Override
    public void queryMore(String nextRecordsUrl, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        Request get = this.getRequest(HttpMethod.GET, this.instanceUrl + nextRecordsUrl, headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(callback));
    }

    @Override
    public void queryAll(String soqlQuery, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soqlQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "queryAll/?q=" + encodedQuery, headers);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException(msg, e));
        }
    }

    @Override
    public void search(String soslQuery, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        try {
            String encodedQuery = this.urlEncode(soslQuery);
            Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "search/?q=" + encodedQuery, headers);
            this.setAccessToken(get);
            this.doHttpRequest(get, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException(msg, e));
        }
    }

    @Override
    public void apexCall(String httpMethod, String apexUrl, Map<String, Object> queryParams, InputStream requestDto, Map<String, List<String>> headers, RestClient.ResponseCallback callback) {
        try {
            Request request = this.getRequest(httpMethod, this.apexCallUrl(apexUrl, queryParams), headers);
            if (requestDto != null) {
                switch (request.getMethod()) {
                    case "PUT": 
                    case "PATCH": 
                    case "POST": {
                        request.content((ContentProvider)new InputStreamContentProvider(requestDto));
                        request.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
                        break;
                    }
                }
            }
            this.setAccessToken(request);
            this.doHttpRequest(request, new DelegatingClientCallback(callback));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException(msg, e));
        }
        catch (URISyntaxException e) {
            String msg = "Unexpected error: " + e.getMessage();
            callback.onResponse(null, Collections.emptyMap(), new SalesforceException(msg, e));
        }
    }

    private String apexCallUrl(String apexUrl, Map<String, Object> queryParams) throws UnsupportedEncodingException, URISyntaxException {
        if (queryParams != null && !queryParams.isEmpty()) {
            apexUrl = URISupport.appendParametersToURI((String)apexUrl, queryParams);
        }
        return this.instanceUrl + SERVICES_APEXREST + apexUrl;
    }

    @Override
    public void recent(Integer limit, Map<String, List<String>> headers, RestClient.ResponseCallback responseCallback) {
        String param = Optional.ofNullable(limit).map(v -> "?limit=" + v).orElse("");
        Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "recent/" + param, headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(responseCallback));
    }

    @Override
    public void limits(Map<String, List<String>> headers, RestClient.ResponseCallback responseCallback) {
        Request get = this.getRequest(HttpMethod.GET, this.versionUrl() + "limits/", headers);
        this.setAccessToken(get);
        this.doHttpRequest(get, new DelegatingClientCallback(responseCallback));
    }

    private String servicesDataUrl() {
        return this.instanceUrl + SERVICES_DATA;
    }

    private String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    private String sobjectsUrl(String sObjectName) {
        ObjectHelper.notNull((Object)sObjectName, (String)"sObjectName");
        return this.versionUrl() + "sobjects/" + sObjectName;
    }

    private String sobjectsExternalIdUrl(String sObjectName, String fieldName, String fieldValue) {
        if (fieldName == null || fieldValue == null) {
            throw new IllegalArgumentException("External field name and value cannot be NULL");
        }
        try {
            String encodedValue = this.urlEncode(fieldValue);
            return this.sobjectsUrl(sObjectName + "/" + fieldName + "/" + encodedValue);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected error: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put(TOKEN_HEADER, TOKEN_PREFIX + this.accessToken);
    }

    private String urlEncode(String query) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(query, "utf-8");
        encodedQuery = encodedQuery.replace("+", "%20");
        return encodedQuery;
    }

    private static class DelegatingClientCallback
    implements AbstractClientBase.ClientResponseCallback {
        private final RestClient.ResponseCallback callback;

        DelegatingClientCallback(RestClient.ResponseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
            this.callback.onResponse(response, headers, ex);
        }
    }
}

