/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");
    private final int major;
    private final int minor;

    private Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static Version create(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("API version needs to be in <number>.<number> format, given: " + version);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        return new Version(major, minor);
    }

    @Override
    public int compareTo(Version other) {
        int majorCompare = Integer.compare(this.major, other.major);
        if (majorCompare == 0) {
            return Integer.compare(this.minor, other.minor);
        }
        return majorCompare;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.compareTo(other) == 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return 1 + 31 * (1 + 31 * this.major) + this.minor;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor;
    }

    public void requireAtLeast(int requiredMajor, int requiredMinor) {
        Version required = new Version(requiredMajor, requiredMinor);
        if (this.compareTo(required) < 0) {
            throw new UnsupportedOperationException("This operation requires API version at least " + requiredMajor + "." + requiredMinor + ", currently configured for " + this.major + "." + this.minor);
        }
    }
}

