/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.composite.ReferenceGenerator;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTree;
import org.apache.camel.util.ObjectHelper;

public final class SObjectNode
implements Serializable {
    private static final String CHILD_PARAM = "child";
    private static final String SOBJECT_TYPE_PARAM = "type";
    private static final long serialVersionUID = 1L;
    @JsonUnwrapped
    final AbstractSObjectBase object;
    final Map<String, List<SObjectNode>> records = new HashMap<String, List<SObjectNode>>();
    private List<RestError> errors;
    private final ReferenceGenerator referenceGenerator;

    SObjectNode(SObjectTree tree, AbstractSObjectBase object) {
        this(tree.referenceGenerator, SObjectNode.typeOf(object), object);
    }

    private SObjectNode(ReferenceGenerator referenceGenerator, String type, AbstractSObjectBase object) {
        this.referenceGenerator = Objects.requireNonNull(referenceGenerator, "ReferenceGenerator cannot be null");
        this.object = Objects.requireNonNull(object, "Root SObject cannot be null");
        object.getAttributes().setReferenceId(referenceGenerator.nextReferenceFor(object));
    }

    static String pluralOf(AbstractDescribedSObjectBase object) {
        SObjectDescription description = object.description();
        return description.getLabelPlural();
    }

    static String typeOf(AbstractDescribedSObjectBase object) {
        SObjectDescription description = object.description();
        return description.getName();
    }

    static String typeOf(AbstractSObjectBase object) {
        return object.getClass().getSimpleName();
    }

    public SObjectNode addChild(AbstractDescribedSObjectBase child) {
        ObjectHelper.notNull((Object)child, (String)CHILD_PARAM);
        return this.addChild(SObjectNode.pluralOf(child), child);
    }

    public SObjectNode addChild(String labelPlural, AbstractSObjectBase child) {
        ObjectHelper.notNull((Object)labelPlural, (String)"labelPlural");
        ObjectHelper.notNull((Object)child, (String)CHILD_PARAM);
        SObjectNode node = new SObjectNode(this.referenceGenerator, SObjectNode.typeOf(child), child);
        return this.addChild(labelPlural, node);
    }

    public void addChildren(AbstractDescribedSObjectBase first, AbstractDescribedSObjectBase ... others) {
        ObjectHelper.notNull((Object)first, (String)"first");
        ObjectHelper.notNull((Object)others, (String)"others");
        this.addChild(SObjectNode.pluralOf(first), first);
        Arrays.stream(others).forEach(this::addChild);
    }

    public void addChildren(String labelPlural, AbstractSObjectBase first, AbstractSObjectBase ... others) {
        ObjectHelper.notNull((Object)labelPlural, (String)"labelPlural");
        ObjectHelper.notNull((Object)first, (String)"first");
        ObjectHelper.notNull((Object)others, (String)"others");
        this.addChild(labelPlural, first);
        Arrays.stream(others).forEach(c -> this.addChild(labelPlural, (AbstractSObjectBase)c));
    }

    @JsonIgnore
    public Stream<SObjectNode> getChildNodes() {
        return this.records.values().stream().flatMap(Collection::stream);
    }

    public Stream<SObjectNode> getChildNodesOfType(String type) {
        ObjectHelper.notNull((Object)type, (String)SOBJECT_TYPE_PARAM);
        return this.records.getOrDefault(type, Collections.emptyList()).stream();
    }

    @JsonIgnore
    public Stream<AbstractSObjectBase> getChildren() {
        return this.records.values().stream().flatMap(Collection::stream).map(SObjectNode::getObject);
    }

    public Stream<AbstractSObjectBase> getChildrenOfType(String type) {
        ObjectHelper.notNull((Object)type, (String)SOBJECT_TYPE_PARAM);
        return this.records.getOrDefault(type, Collections.emptyList()).stream().map(SObjectNode::getObject);
    }

    @JsonIgnore
    public List<RestError> getErrors() {
        return Optional.ofNullable(this.errors).orElse(Collections.emptyList());
    }

    @JsonIgnore
    public AbstractSObjectBase getObject() {
        return this.object;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public int size() {
        return 1 + this.records.values().stream().flatMapToInt(r -> r.stream().mapToInt(SObjectNode::size)).sum();
    }

    public String toString() {
        return "Node<" + this.getObjectType() + ">";
    }

    SObjectNode addChild(String labelPlural, SObjectNode node) {
        List children = this.records.computeIfAbsent(labelPlural, k -> new ArrayList());
        children.add(node);
        return node;
    }

    @JsonAnyGetter
    Map<String, Map<String, List<SObjectNode>>> children() {
        return this.records.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonMap("records", e.getValue())));
    }

    @JsonIgnore
    String getObjectType() {
        return this.object.getAttributes().getType();
    }

    Stream<Class> objectTypes() {
        return Stream.concat(Stream.of(this.object.getClass()), this.getChildNodes().flatMap(SObjectNode::objectTypes));
    }

    void setErrors(List<RestError> errors) {
        this.errors = errors;
    }
}

