/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AbstractReportResultsBase;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AggregateColumnInfo;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AsyncReportResults;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.DetailColumnInfo;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.GroupingColumnInfo;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.GroupingInfo;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.GroupingValue;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportExtendedMetadata;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportFactWithDetails;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportRow;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportStatusEnum;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.SummaryValue;

@Converter(generateLoader=true)
public final class SalesforceReportResultsToListConverter {
    public static final String INCLUDE_DETAILS = "CamelSalesforceIncludeDetails";
    public static final String INCLUDE_HEADERS = "CamelSalesforceIncludeHeaders";
    public static final String INCLUDE_SUMMARY = "CamelSalesforceIncludeSummary";
    private static final String ROW_COUNT = "RowCount";
    private static final String EMPTY_VALUE = "";
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();

    private SalesforceReportResultsToListConverter() {
    }

    @Converter
    public static List<List<String>> convertToList(AbstractReportResultsBase reportResults, Exchange exchange) {
        AsyncReportResults asyncReportResults;
        ReportStatusEnum status;
        List<List<String>> results = null;
        if (reportResults instanceof AsyncReportResults && (status = (asyncReportResults = (AsyncReportResults)reportResults).getAttributes().getStatus()) != ReportStatusEnum.Success) {
            throw new IllegalArgumentException("Invalid asynchronous report results status " + (Object)((Object)status));
        }
        switch (reportResults.getReportMetadata().getReportFormat()) {
            case TABULAR: {
                results = SalesforceReportResultsToListConverter.convertTabularResults(reportResults, exchange);
                break;
            }
            case SUMMARY: {
                results = SalesforceReportResultsToListConverter.convertSummaryResults(reportResults, exchange);
                break;
            }
            case MATRIX: {
                results = SalesforceReportResultsToListConverter.convertMatrixResults(reportResults, exchange);
                break;
            }
        }
        return results;
    }

    private static List<List<String>> convertTabularResults(AbstractReportResultsBase reportResults, Exchange exchange) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ReportMetadata reportMetadata = reportResults.getReportMetadata();
        String[] detailColumns = reportMetadata.getDetailColumns();
        ReportExtendedMetadata reportExtendedMetadata = reportResults.getReportExtendedMetadata();
        ReportFactWithDetails factWithDetails = reportResults.getFactMap().get("T!T");
        String[] aggregates = reportMetadata.getAggregates();
        if (reportResults.getHasDetailRows().booleanValue() && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_DETAILS, Boolean.TRUE)) {
            int rowLength = detailColumns.length;
            if (SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_HEADERS, Boolean.TRUE)) {
                ArrayList<String> headers = new ArrayList<String>(rowLength);
                result.add(headers);
                SalesforceReportResultsToListConverter.addColumnHeaders(headers, reportExtendedMetadata.getDetailColumnInfo(), detailColumns);
            }
            ReportRow[] reportRows = factWithDetails.getRows();
            result.ensureCapacity(result.size() + reportRows.length);
            for (ReportRow reportRow : reportRows) {
                ArrayList<String> row = new ArrayList<String>(rowLength);
                result.add(row);
                SalesforceReportResultsToListConverter.addRowValues(row, reportRow.getDataCells());
            }
            if (aggregates.length > 0 && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_SUMMARY, Boolean.TRUE)) {
                SalesforceReportResultsToListConverter.addSummaryRows(result, detailColumns, null, aggregates, factWithDetails.getAggregates());
            }
        } else if (aggregates.length > 0) {
            int rowLength = aggregates.length;
            if (SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_HEADERS, Boolean.TRUE)) {
                ArrayList<String> headers = new ArrayList<String>(rowLength);
                result.add(headers);
                SalesforceReportResultsToListConverter.addColumnHeaders(headers, reportExtendedMetadata.getAggregateColumnInfo(), aggregates);
            }
            ArrayList<String> row = new ArrayList<String>(rowLength);
            result.add(row);
            SalesforceReportResultsToListConverter.addRowValues(row, factWithDetails.getAggregates());
        }
        return result;
    }

    private static List<List<String>> convertSummaryResults(AbstractReportResultsBase reportResults, Exchange exchange) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ReportMetadata reportMetadata = reportResults.getReportMetadata();
        ReportExtendedMetadata reportExtendedMetadata = reportResults.getReportExtendedMetadata();
        String[] aggregates = reportMetadata.getAggregates();
        boolean includeDetails = reportResults.getHasDetailRows() != false && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_DETAILS, Boolean.TRUE);
        boolean includeSummary = aggregates.length > 0 && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_SUMMARY, Boolean.TRUE);
        ArrayList<DetailColumnInfo> columnInfos = new ArrayList<DetailColumnInfo>();
        String[] columnNames = SalesforceReportResultsToListConverter.getResultColumns(columnInfos, reportMetadata, reportExtendedMetadata, includeDetails, includeSummary);
        if (SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_HEADERS, Boolean.TRUE)) {
            SalesforceReportResultsToListConverter.addColumnHeaders(result, columnInfos);
        }
        for (GroupingValue groupingValue : reportResults.getGroupingsDown().getGroupings()) {
            SalesforceReportResultsToListConverter.addSummaryGroupValues(result, reportResults, columnNames, groupingValue, EMPTY_STRING_LIST, includeDetails, includeSummary);
        }
        if (includeSummary) {
            ReportFactWithDetails grandTotal = reportResults.getFactMap().get("T!T");
            SalesforceReportResultsToListConverter.addSummaryValues(result, includeDetails, columnNames, EMPTY_STRING_LIST, aggregates, grandTotal.getAggregates());
        }
        return result;
    }

    private static List<List<String>> convertMatrixResults(AbstractReportResultsBase reportResults, Exchange exchange) {
        GroupingValue[] groupingsDown;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ReportMetadata reportMetadata = reportResults.getReportMetadata();
        ReportExtendedMetadata reportExtendedMetadata = reportResults.getReportExtendedMetadata();
        String[] aggregates = reportMetadata.getAggregates();
        boolean includeDetails = reportResults.getHasDetailRows() != false && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_DETAILS, Boolean.TRUE);
        boolean includeSummary = aggregates.length > 0 && SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_SUMMARY, Boolean.TRUE);
        ArrayList<DetailColumnInfo> columnInfos = new ArrayList<DetailColumnInfo>();
        String[] columnNames = SalesforceReportResultsToListConverter.getResultColumns(columnInfos, reportMetadata, reportExtendedMetadata, includeDetails, includeSummary);
        if (SalesforceReportResultsToListConverter.getOption(exchange, INCLUDE_HEADERS, Boolean.TRUE)) {
            SalesforceReportResultsToListConverter.addColumnHeaders(result, columnInfos);
        }
        for (GroupingValue groupingValue : groupingsDown = reportResults.getGroupingsDown().getGroupings()) {
            SalesforceReportResultsToListConverter.addMatrixGroupValues(result, reportResults, columnNames, groupingValue, EMPTY_STRING_LIST, includeDetails, includeSummary, EMPTY_VALUE, true);
        }
        if (includeSummary) {
            Map<String, ReportFactWithDetails> factMap = reportResults.getFactMap();
            ArrayList<String> downGroupsPrefix = new ArrayList<String>(Collections.nCopies(groupingsDown.length, EMPTY_VALUE));
            for (GroupingValue acrossGrouping : reportResults.getGroupingsAcross().getGroupings()) {
                SalesforceReportResultsToListConverter.addAcrossGroupSummaryValues(result, reportMetadata, includeDetails, columnNames, factMap, downGroupsPrefix, acrossGrouping);
            }
            ReportFactWithDetails grandTotal = factMap.get("T!T");
            SalesforceReportResultsToListConverter.addSummaryValues(result, includeDetails, columnNames, EMPTY_STRING_LIST, reportResults.getReportMetadata().getAggregates(), grandTotal.getAggregates());
        }
        return result;
    }

    private static void addAcrossGroupSummaryValues(ArrayList<List<String>> result, ReportMetadata reportMetadata, boolean includeDetails, String[] columnNames, Map<String, ReportFactWithDetails> factMap, List<String> downGroupsPrefix, GroupingValue acrossGrouping) {
        ArrayList<String> newDownGroupsPrefix = new ArrayList<String>(downGroupsPrefix);
        newDownGroupsPrefix.add(acrossGrouping.getLabel());
        SalesforceReportResultsToListConverter.addSummaryValues(result, includeDetails, columnNames, newDownGroupsPrefix, reportMetadata.getAggregates(), factMap.get("T!" + acrossGrouping.getKey()).getAggregates());
        for (GroupingValue subGroup : acrossGrouping.getGroupings()) {
            SalesforceReportResultsToListConverter.addAcrossGroupSummaryValues(result, reportMetadata, includeDetails, columnNames, factMap, newDownGroupsPrefix, subGroup);
        }
    }

    private static void addMatrixGroupValues(ArrayList<List<String>> result, AbstractReportResultsBase reportResults, String[] columnNames, GroupingValue groupingValue, List<String> rowPrefix, boolean includeDetails, boolean includeSummary, String keyPrefix, boolean downGroup) {
        String groupKey = groupingValue.getKey();
        String newKeyPrefix = keyPrefix + groupKey;
        ArrayList<String> newPrefix = new ArrayList<String>(rowPrefix);
        newPrefix.add(groupingValue.getLabel());
        GroupingValue[] groupings = groupingValue.getGroupings();
        if (groupings.length > 0) {
            for (GroupingValue subGroup : groupings) {
                SalesforceReportResultsToListConverter.addMatrixGroupValues(result, reportResults, columnNames, subGroup, newPrefix, includeDetails, includeSummary, newKeyPrefix + "_", downGroup);
            }
        } else if (downGroup) {
            for (GroupingValue acrossGroup : reportResults.getGroupingsAcross().getGroupings()) {
                SalesforceReportResultsToListConverter.addMatrixGroupValues(result, reportResults, columnNames, acrossGroup, newPrefix, includeDetails, includeSummary, newKeyPrefix + "!", false);
            }
        } else if (includeDetails) {
            SalesforceReportResultsToListConverter.addDetailRows(result, newPrefix, reportResults.getFactMap().get(newKeyPrefix));
        } else if (!includeSummary) {
            result.add(newPrefix);
        }
        if (includeSummary) {
            String summaryKey = SalesforceReportResultsToListConverter.getGroupTotalKey(keyPrefix, downGroup, groupKey);
            SalesforceReportResultsToListConverter.addSummaryValues(result, includeDetails, columnNames, newPrefix, reportResults.getReportMetadata().getAggregates(), reportResults.getFactMap().get(summaryKey).getAggregates());
        }
    }

    private static String getGroupTotalKey(String keyPrefix, boolean downGroup, String key) {
        if (downGroup) {
            return keyPrefix + key + "!T";
        }
        return keyPrefix + key;
    }

    private static void addSummaryGroupValues(ArrayList<List<String>> result, AbstractReportResultsBase reportResults, String[] columnNames, GroupingValue groupingValue, List<String> rowPrefix, boolean includeDetails, boolean includeSummary) {
        ReportFactWithDetails factWithDetails = reportResults.getFactMap().get(groupingValue.getKey() + "!T");
        ArrayList<String> newPrefix = new ArrayList<String>(rowPrefix);
        newPrefix.add(groupingValue.getLabel());
        GroupingValue[] groupings = groupingValue.getGroupings();
        if (groupings.length > 0) {
            for (GroupingValue subGroup : groupings) {
                SalesforceReportResultsToListConverter.addSummaryGroupValues(result, reportResults, columnNames, subGroup, newPrefix, includeDetails, includeSummary);
            }
        } else if (includeDetails) {
            SalesforceReportResultsToListConverter.addDetailRows(result, newPrefix, factWithDetails);
        } else if (!includeSummary) {
            result.add(newPrefix);
        }
        if (includeSummary) {
            SummaryValue[] summaryValues = factWithDetails.getAggregates();
            String[] aggregates = reportResults.getReportMetadata().getAggregates();
            SalesforceReportResultsToListConverter.addSummaryValues(result, includeDetails, columnNames, newPrefix, aggregates, summaryValues);
        }
    }

    private static void addDetailRows(ArrayList<List<String>> result, List<String> newPrefix, ReportFactWithDetails factWithDetails) {
        ReportRow[] rows = factWithDetails.getRows();
        result.ensureCapacity(result.size() + rows.length);
        for (ReportRow row : rows) {
            ArrayList<String> rowValues = new ArrayList<String>(newPrefix);
            SalesforceReportResultsToListConverter.addRowValues(rowValues, row.getDataCells());
            result.add(rowValues);
        }
    }

    private static void addSummaryValues(ArrayList<List<String>> result, boolean includeDetails, String[] columnNames, List<String> newPrefix, String[] aggregates, SummaryValue[] summaryValues) {
        if (summaryValues.length == 0) {
            return;
        }
        if (includeDetails) {
            SalesforceReportResultsToListConverter.addSummaryRows(result, columnNames, newPrefix, aggregates, summaryValues);
        } else {
            ArrayList<String> summaryRow = new ArrayList<String>(newPrefix);
            int nGroups = columnNames.length - summaryValues.length;
            for (int i = summaryRow.size(); i < nGroups; ++i) {
                summaryRow.add(EMPTY_VALUE);
            }
            SalesforceReportResultsToListConverter.addRowValues(summaryRow, summaryValues);
            result.add(summaryRow);
        }
    }

    private static void addSummaryRows(List<List<String>> result, String[] detailColumns, List<String> rowPrefix, String[] aggregateColumns, SummaryValue[] summaryValues) {
        ArrayList rows = new ArrayList(summaryValues.length + 1);
        String rowCount = null;
        for (int i = 0; i < aggregateColumns.length; ++i) {
            int j;
            String aggregate = aggregateColumns[i];
            String valueLabel = summaryValues[i].getLabel();
            if (ROW_COUNT.equals(aggregate)) {
                rowCount = valueLabel;
                continue;
            }
            ArrayList<String> summaryRow = rowPrefix == null ? new ArrayList<String>() : new ArrayList<String>(rowPrefix);
            rows.add(summaryRow);
            int n = j = rowPrefix == null ? 0 : rowPrefix.size();
            while (j < detailColumns.length) {
                String columnName = detailColumns[j];
                if (aggregate.endsWith("!" + columnName)) {
                    StringBuilder valueBuilder = new StringBuilder();
                    if (aggregate.startsWith("a!")) {
                        valueBuilder.append("avg ");
                    } else if (aggregate.startsWith("mx!")) {
                        valueBuilder.append("max ");
                    } else if (aggregate.startsWith("m!")) {
                        valueBuilder.append("min ");
                    }
                    valueBuilder.append(valueLabel);
                    summaryRow.add(valueBuilder.toString());
                } else {
                    summaryRow.add(EMPTY_VALUE);
                }
                ++j;
            }
        }
        ArrayList<String> grandTotal = new ArrayList<String>();
        result.add(grandTotal);
        if (rowCount != null) {
            grandTotal.add("Grand Totals (" + rowCount + " records)");
        } else {
            grandTotal.add("Grand Totals");
        }
        result.addAll(rows);
    }

    private static String[] getResultColumns(List<DetailColumnInfo> result, ReportMetadata reportMetadata, ReportExtendedMetadata reportExtendedMetadata, boolean includeDetails, boolean includeSummary) {
        ArrayList<String> columnNames;
        block5: {
            block4: {
                String name;
                columnNames = new ArrayList<String>();
                Map<String, GroupingColumnInfo> groupingColumnInfos = reportExtendedMetadata.getGroupingColumnInfo();
                for (GroupingInfo downGroup : reportMetadata.getGroupingsDown()) {
                    name = downGroup.getName();
                    columnNames.add(name);
                    result.add(groupingColumnInfos.get(name));
                }
                for (GroupingInfo acrossGroup : reportMetadata.getGroupingsAcross()) {
                    name = acrossGroup.getName();
                    columnNames.add(name);
                    result.add(groupingColumnInfos.get(name));
                }
                if (includeDetails) break block4;
                if (!includeSummary) break block5;
                Map<String, AggregateColumnInfo> aggregateColumnInfos = reportExtendedMetadata.getAggregateColumnInfo();
                for (String aggregateColumnName : reportMetadata.getAggregates()) {
                    columnNames.add(aggregateColumnName);
                    result.add(aggregateColumnInfos.get(aggregateColumnName));
                }
                break block5;
            }
            Map<String, DetailColumnInfo> detailColumnInfo = reportExtendedMetadata.getDetailColumnInfo();
            for (String columnName : reportMetadata.getDetailColumns()) {
                columnNames.add(columnName);
                result.add(detailColumnInfo.get(columnName));
            }
        }
        return columnNames.toArray(new String[columnNames.size()]);
    }

    private static void addColumnHeaders(List<String> headers, Map<String, ? extends DetailColumnInfo> columnInfos, String[] columns) {
        for (String columnName : columns) {
            headers.add(columnInfos.get(columnName).getLabel());
        }
    }

    private static void addColumnHeaders(List<List<String>> result, ArrayList<DetailColumnInfo> columnInfos) {
        ArrayList<String> headers = new ArrayList<String>(columnInfos.size());
        for (DetailColumnInfo info : columnInfos) {
            headers.add(info.getLabel());
        }
        result.add(headers);
    }

    private static void addRowValues(List<String> row, SummaryValue[] values) {
        for (SummaryValue summaryValue : values) {
            row.add(summaryValue.getLabel());
        }
    }

    private static boolean getOption(Exchange exchange, String name, Boolean defaultValue) {
        return (Boolean)exchange.getIn().getHeader(name, (Object)defaultValue, Boolean.class);
    }
}

