/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.SalesforceHttpRequest;
import org.apache.camel.component.salesforce.internal.client.SalesforceSecurityHandler;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SalesforceHttpClient
extends HttpClient {
    static final long DEFAULT_TIMEOUT = 60000L;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 0x400000;
    private final CamelContext camelContext;
    private SalesforceSession session;
    private int maxRetries = 3;
    private int maxContentLength = 0x400000;
    private long timeout = 60000L;
    private final Method addProtocolHandlerMethod;
    private final Method getProtocolHandlersMethod;
    private final ExecutorService workerPool;

    public SalesforceHttpClient() {
        this(null);
    }

    public SalesforceHttpClient(SslContextFactory sslContextFactory) {
        this(null, Executors.newCachedThreadPool(), sslContextFactory);
    }

    public SalesforceHttpClient(CamelContext context, ExecutorService workerPool, SslContextFactory sslContextFactory) {
        super((HttpClientTransport)new HttpClientTransportOverHTTP(), sslContextFactory);
        this.workerPool = workerPool;
        this.camelContext = context;
        try {
            Class<?> getProtocolHandlersType = HttpClient.class.getMethod("getProtocolHandlers", new Class[0]).getReturnType();
            boolean isJetty92 = List.class.equals(getProtocolHandlersType);
            this.addProtocolHandlerMethod = isJetty92 ? List.class.getMethod("add", Object.class) : getProtocolHandlersType.getMethod("put", ProtocolHandler.class);
            this.getProtocolHandlersMethod = HttpClient.class.getMethod("getProtocolHandlers", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Found no method of adding SalesforceSecurityHandler as ProtocolHandler to Jetty HttpClient. You need Jetty 9.2 or newer on the classpath.");
        }
    }

    public HttpRequest newHttpRequest(HttpConversation conversation, URI uri) {
        SalesforceHttpRequest request = new SalesforceHttpRequest(this, conversation, uri);
        request.timeout(this.timeout, TimeUnit.MILLISECONDS);
        return request;
    }

    public Request copyRequest(HttpRequest oldRequest, URI newURI) {
        return super.copyRequest(oldRequest, newURI);
    }

    protected void doStart() throws Exception {
        if (this.getSession() == null) {
            throw new IllegalStateException("Missing SalesforceSession in property session!");
        }
        Object protocolHandlers = this.getProtocolHandlersMethod.invoke((Object)this, new Object[0]);
        this.addProtocolHandlerMethod.invoke(protocolHandlers, new SalesforceSecurityHandler(this));
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.workerPool != null) {
            if (this.camelContext != null) {
                this.camelContext.getExecutorServiceManager().shutdownGraceful(this.workerPool);
            } else {
                this.workerPool.shutdown();
            }
        }
        super.doStop();
    }

    public SalesforceSession getSession() {
        return this.session;
    }

    public void setSession(SalesforceSession session) {
        this.session = session;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }
}

