/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty4.ChannelHandlerFactory;
import org.apache.camel.component.netty4.ClientInitializerFactory;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyProducer;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpProducer;
import org.apache.camel.component.netty4.http.handlers.HttpClientChannelHandler;
import org.apache.camel.component.netty4.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientInitializerFactory
extends ClientInitializerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientInitializerFactory.class);
    protected NettyHttpConfiguration configuration;
    private NettyHttpProducer producer;
    private SSLContext sslContext;

    public HttpClientInitializerFactory() {
    }

    public HttpClientInitializerFactory(NettyHttpProducer nettyProducer) {
        this.producer = nettyProducer;
        try {
            this.sslContext = this.createSSLContext(this.producer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
        this.configuration = nettyProducer.getConfiguration();
    }

    public ClientInitializerFactory createPipelineFactory(NettyProducer nettyProducer) {
        return new HttpClientInitializerFactory((NettyHttpProducer)nettyProducer);
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Client SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("http", (ChannelHandler)new HttpClientCodec());
        List encoders = this.producer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = (ChannelHandler)encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            pipeline.addLast("encoder-" + x, encoder);
        }
        List decoders = this.producer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = (ChannelHandler)decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            pipeline.addLast("decoder-" + x, decoder);
        }
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.configuration.getChunkedMaxContentLength()));
        if (this.producer.getConfiguration().getRequestTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using request timeout {} millis", (Object)this.producer.getConfiguration().getRequestTimeout());
            }
            ReadTimeoutHandler timeout = new ReadTimeoutHandler(this.producer.getConfiguration().getRequestTimeout(), TimeUnit.MILLISECONDS);
            pipeline.addLast("timeout", (ChannelHandler)timeout);
        }
        pipeline.addLast("handler", (ChannelHandler)new HttpClientChannelHandler(this.producer));
    }

    private SSLContext createSSLContext(NettyProducer producer) throws Exception {
        SSLContext answer;
        NettyConfiguration configuration = producer.getConfiguration();
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext(producer.getContext());
        } else {
            if (configuration.getKeyStoreFile() == null && configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (configuration.getTrustStoreFile() == null && configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(true);
            if (this.producer.getConfiguration().getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.producer.getConfiguration().getEnabledProtocols().split(","));
            }
            return new SslHandler(engine);
        }
        return null;
    }
}

