/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.subcription;

import java.util.Iterator;
import org.apache.camel.component.kafka.consumer.support.TopicHelper;
import org.apache.camel.component.kafka.consumer.support.subcription.SubscribeAdapter;
import org.apache.camel.component.kafka.consumer.support.subcription.TopicInfo;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscribeAdapter
implements SubscribeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSubscribeAdapter.class);
    private final String topic;
    private final boolean topicMustExists;

    public DefaultSubscribeAdapter() {
        this(null, false);
    }

    public DefaultSubscribeAdapter(String topic, boolean topicMustExists) {
        this.topic = topic;
        this.topicMustExists = topicMustExists;
    }

    @Override
    public void subscribe(Consumer<?, ?> consumer, ConsumerRebalanceListener reBalanceListener, TopicInfo topicInfo) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Subscribing to {}", (Object)TopicHelper.getPrintableTopic(topicInfo));
        }
        if (topicInfo.isPattern()) {
            consumer.subscribe(topicInfo.getPattern(), reBalanceListener);
        } else {
            consumer.subscribe(topicInfo.getTopics(), reBalanceListener);
        }
        if (this.topicMustExists) {
            boolean found = false;
            Iterator it = consumer.listTopics().keySet().iterator();
            while (!found && it.hasNext()) {
                String id = (String)it.next();
                if (topicInfo.isPattern()) {
                    found = topicInfo.getPattern().matcher(id).matches();
                    continue;
                }
                found = topicInfo.getTopics().contains(id);
            }
            if (!found) {
                throw new UnknownTopicOrPartitionException("Topic " + this.topic + " does not exists");
            }
        }
    }
}

